% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{cbc_balance}
\alias{cbc_balance}
\title{Counts of attribute balance}
\usage{
cbc_balance(design)
}
\arguments{
\item{design}{A data frame of a survey design.}
}
\value{
Prints the individual and pairwise counts of the number of times
each attribute levels in shown in the design.
}
\description{
This function prints out a summary of the individual and pairwise counts of
each level for each attribute across all choice questions in the design.
}
\examples{
library(cbcTools)

# A simple conjoint experiment about apples

# Generate all possible profiles
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  type      = c("Fuji", "Gala", "Honeycrisp"),
  freshness = c('Poor', 'Average', 'Excellent')
)

# Make a survey design from all possible profiles
# (This is the default setting where method = 'full' for "full factorial")
design <- cbc_design(
  profiles = profiles,
  n_resp   = 300, # Number of respondents
  n_alts   = 3,   # Number of alternatives per question
  n_q      = 6    # Number of questions per respondent
)

# Inspect the design balance
cbc_balance(design)

# Inspect the design overlap
cbc_overlap(design)
}
\keyword{balance}
\keyword{logit}
\keyword{logitr}
\keyword{mixed}
\keyword{mnl}
\keyword{mxl}
\keyword{overlap}
