% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{bcluster.h}
\alias{bcluster.h}
\title{b-cluster analysis by hierarchical agglomerative strategy}
\usage{
bcluster.h(X, measure = "b", runs = 1, seed = 2021)
}
\arguments{
\item{X}{three-way array; the \code{I, J, M} array has \code{I}
assessors, \code{J} products, \code{M} attributes where CATA data have values 
\code{0} (not checked) and \code{1} (checked)}

\item{measure}{currently only \code{b} (the \code{b}-measure) is implemented}

\item{runs}{number of runs (defaults to \code{1}; use a higher number of
runs for a real application)}

\item{seed}{for reproducibility (default is \code{2021})}
}
\value{
An object of class \code{hclust} from hierarchical b-cluster 
analysis results (a list of such objects if \code{runs>1}), where each \code{hclust} 
object has the structure described in \code{\link[stats]{hclust}} as well as 
the item \code{retainedB} (a vector indicating the retained sensory 
differentiation at each iteration (merger)).
}
\description{
Perform b-clustering using the hierarchical agglomerative clustering 
strategy.
}
\examples{
data(bread)

# hierarchical b-cluster analysis on first 8 consumers and first 5 attributes
b <- bcluster.h(bread$cata[1:8,,1:5])

plot(as.dendrogram(b), 
  main = "Hierarchical b-cluster analysis", 
  sub = "8 bread consumers on 5 attributes")
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
