% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalClusterQuality.R
\encoding{UTF-8}
\name{selectionPlot}
\alias{selectionPlot}
\title{Plot variation in retained sensory differentiation}
\usage{
selectionPlot(x, pctB = NULL, x.input = "deltaB", indx = NULL, 
ylab = "change in B (K to G)", xlab = NULL)
}
\arguments{
\item{x}{input vector which is either deltaB (default; change 
in sensory differentiation retained) or B (sensory differentiation 
retained) if \code{x.input} is \code{"B"}}

\item{pctB}{vector of percentage of the total sensory differentiation retained}

\item{x.input}{indicates what \code{x} is; either \code{"deltaB"} (default) 
or \code{B}.}

\item{indx}{numeric value indicating which point(s) to emphasize}

\item{ylab}{label shown on y axis and at selection point}

\item{xlab}{label for points along x axis}
}
\description{
Plot variation in retained sensory differentiation of cluster memberships
obtained from b-cluster analysis. This plot can be used to help the decision
of how many clusters to retain.
}
\examples{
set.seed(123)
G2 <- bcluster.n(bread$cata[1:12, , 1:8], G = 2, runs = 3)
G3 <- bcluster.n(bread$cata[1:12, , 1:8], G = 3, runs = 3)
G4 <- bcluster.n(bread$cata[1:12, , 1:8], G = 4, runs = 3)

best.indx <- c(which.max(unlist(lapply(G2, function(x) x$retainedB))),
               which.max(unlist(lapply(G3, function(x) x$retainedB))),
               which.max(unlist(lapply(G4, function(x) x$retainedB))))
               
G1.bc <- barray(bread$cata[1:12, , 1:8])
G1.B <- getb(G1.bc[,,1,], G1.bc[,,2,])
BpctB <- data.frame(retainedB = c(G1.B, 
                                  G2[[best.indx[1]]]$retainedB, 
                                  G3[[best.indx[2]]]$retainedB,
                                  G4[[best.indx[3]]]$retainedB))
BpctB$pctB <- 100*BpctB$retainedB / G2[[1]]$totalB
BpctB$deltaB <- 
           c(100*(1-BpctB$retainedB[-nrow(BpctB)] / BpctB$retainedB[-1]), NA)
BpctB <- BpctB[-nrow(BpctB),]

opar <- par(no.readonly=TRUE)
par(mar = rep(5,4))
selectionPlot(BpctB$deltaB, BpctB$pctB, indx = 2)
par(opar)
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
