% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carfima.loglik.R
\name{carfima.loglik}
\alias{carfima.loglik}
\title{Computing the log likelihood function of a CARFIMA(p, H, q) model}
\usage{
carfima.loglik(Y, time, ar.p, ma.q, parameter, fitted = FALSE)
}
\arguments{
\item{Y}{A vector for the \eqn{k} observed data.}

\item{time}{A vector for the \eqn{k} observation times.}

\item{ar.p}{A positive integer for the order of the AR model. \code{ar.p} must be greater than \code{ma.q}. 
If \code{ar.p} is greater than 2, numerical errors may occur for both methods.}

\item{ma.q}{A non-negative integer for the order of the MA model. \code{ma.q} must be smaller than \code{ar.p}.}

\item{parameter}{The values of the unknown parameters at which the log likelihood is evaluated. 
For example, users need to specify five values, \eqn{\alpha_1}, \eqn{\alpha_2}, \eqn{\beta_1}, \eqn{H}, and \eqn{\sigma} 
for \code{CARFIMA(2,H,1)}.}

\item{fitted}{If \code{TRUE}, fitted values and AIC are returned as a list. \code{FALSE} flag returns a value of the log likelihood.}
}
\value{
Either a list of fitted values(\code{fitted}) and AIC(\code{AIC}), or a numeric value of the log likelihood.
}
\description{
Computing the log likelihood function of a CARFIMA(p, H, q) model
}
\section{Details}{

The function \code{carfima.loglik} computes the log likelihood of a \code{CARFIMA(p,H,q)} model via the innovation algorithm 
whose computational cost increases linearly as the size of the data increases. See the reference for details.
}

\examples{
\donttest{
##### Irregularly spaced observation time generation.
length.time <- 100
time.temp <- rexp(length.time, rate = 2)
time <- rep(NA, length.time + 1)
time[1] <- 0
for (i in 2 : (length.time + 1)) {
  time[i] <- time[i - 1] + time.temp[i - 1]
  }
  time <- time[-1]

##### Data genration for CARFIMA(1, H, 0) based on the observation times.
parameter <- c(-0.4, 0.75, 0.2)
# AR parameter alpha = -0.4
# Hurst parameter = 0.75
# process uncertainty (standard deviation) sigma = 0.2
y <- carfima.sim(parameter = parameter, time = time, ar.p = 1, ma.q = 0)

##### Compute
output = carfima::carfima.loglik(Y=y,time=time,ar.p=1,ma.q=0,parameter=parameter,fitted=TRUE)
}

}
\references{
\insertRef{tsai_note_2000}{carfima} 

\insertRef{tsai_maximum_2005}{carfima}
}
