% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretStack.R
\name{caretStack}
\alias{caretStack}
\title{Combine several predictive models via stacking}
\usage{
caretStack(all.models, ...)
}
\arguments{
\item{all.models}{a list of caret models to ensemble.}

\item{...}{additional arguments to pass to the optimization function}
}
\value{
S3 caretStack object
}
\description{
Find a good linear combination of several classification or regression models,
using either linear regression, elastic net regression, or greedy optimization.
}
\details{
Check the models, and make a matrix of obs and preds
}
\examples{
\dontrun{
library("rpart")
models <- caretList(
  x=iris[1:50,1:2],
  y=iris[1:50,3],
  trControl=trainControl(method="cv"),
  methodList=c("rpart", "glm")
)
caretStack(models, method="glm")
}
}
\references{
\url{http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.60.2859&rep=rep1&type=pdf}
}
