% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_t_test.R
\name{.format_ttest_results}
\alias{.format_ttest_results}
\title{Convert t-test to ARD}
\usage{
.format_ttest_results(by = NULL, variable, lst_tidy, paired, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variable}{(\code{string})\cr variable column name}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{...}{passed to \code{t.test(...)}}
}
\value{
ARD data frame
}
\description{
Convert t-test to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cardx:::.format_ttest_results(
  by = "ARM",
  variable = "AGE",
  paired = FALSE,
  lst_tidy =
    cards::eval_capture_conditions(
      stats::t.test(ADSL[["AGE"]] ~ ADSL[["ARM"]], paired = FALSE) |>
        broom::tidy()
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
