% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_sym.R
\name{def_sym}
\alias{def_sym}
\title{Define caracas symbols in global environment}
\usage{
def_sym(..., charvec = NULL, warn = FALSE, env = parent.frame())
}
\arguments{
\item{...}{Names for new symbols, also supports non-standard evaluation}

\item{charvec}{Take each element in this character vector and define as caracas symbols}

\item{warn}{Warn if existing variable names are overwritten}

\item{env}{Environment to assign variable in}
}
\value{
Names of declared variables (invisibly)
}
\description{
Define caracas symbols in global environment
}
\examples{
if (has_sympy()) {
  ls()
  def_sym(n1, n2, n3)
  ls()
  def_sym("x1", "x2", "x3")
  ls()
  def_sym("x1", "x2", "x3", warn = TRUE)
  ls()
  def_sym(i, j, charvec = c("x", "y"))
  ls()
}

}
\seealso{
\code{\link[=symbol]{symbol()}}, \code{\link[=as_sym]{as_sym()}}
}
\concept{caracas_symbol}
