% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolveSI.R
\name{SolveSI}
\alias{SolveSI}
\title{Modelling of sterilization and immigration of comapnion animals.}
\usage{
SolveSI(pars = NULL, init = NULL, time = NULL, dd = "b", im = 0,
  s.range = NULL, ...)
}
\arguments{
\item{pars}{\code{\link{vector}} of length 4. The values are point estimates of birth rate, death rate, carrying capacity and sterilization rate. The names of this values must be "b", "d", "k" and "s", respectively.}

\item{init}{\code{\link{vector}} of length 2. The values are initial population size and initial proportion of sterilized animals. The names of this values must be "n" and "q", respectively.}

\item{time}{time sequence for which output is wanted; the first value of times must be the initial time.}

\item{dd}{string equal to \code{b} or \code{d} to define if density-dependece act on birth or death rartes respectively.}

\item{im}{a number representing the total of immigrants per time unit.}

\item{s.range}{optional sequence (between 0 and 1) of the sterilization rates to be simulated.}

\item{...}{further arguments passed to \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{name}, is a string with the name of the function, the second element, \code{model}, is the model function. The third, fourth and fifth elements are vectors (\code{pars}, \code{init}, \code{time}, respectively) containing the \code{pars}, \code{init} and \code{time} arguments of the function. The sisxth element \code{results} is a \code{\link{data.frame}} with up to as many rows as elements in time. First column contains the time, second column the population size and third column the proportion of sterilized animals. If \code{s.range} is specified, fourth column contains its specific instances.
}
\description{
System of ordinary differential equations to simulate the effect of sterilization and immigration on population dynamics.
}
\details{
The implemented model is described by Amaku, et. al., 2009 and the function is a wrapper around the defaults of \link[deSolve]{ode} function, whose help page must be consulted for details.
}
\note{
Logistic growth models are not intended for scenarios in which population size is greater than carrying capacity and growth rate is negative.
}
\examples{
# Parameters and initial conditions from estimates   
# obtained in examples section from svysumm function but
# estimating a proportion insted of a total for births.
pars.solve.si = c(b = 0.245, d = 0.101, 
                 k = 98050, s = 0.048)
init.solve.si = c(n = 89137, q = 0.198)

# Solve for a specific sterilization rate.
solvesi.pt = SolveSI(pars = pars.solve.si, 
                     init = init.solve.si, 
                     time = 0:15, dd = 'b',
                     im = 100, method = 'rk4')

# Solve for a range of sterilization rates.
solvesi.rg = SolveSI(pars = pars.solve.si,
                     init = init.solve.si,
                     time = 0:15, dd = 'b', im = 100, 
                     s.range = seq(0, .4, l = 50),
                     method = 'rk4')

}
\references{
Amaku M, Dias R and Ferreira F (2009). Dinamica populacional canina: potenciais efeitos de campanhas de esterilizacao. Revista Panamericana de Salud Publica, 25(4), pp. 300-304.

Soetaert K, Cash J and Mazzia F (2012). Solving differential equations in R. Springer.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[deSolve]{ode}.
}

