% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateStratifiedSampleSize.R
\name{CalculateStratifiedSampleSize}
\alias{CalculateStratifiedSampleSize}
\title{Stratified random sample size}
\usage{
CalculateStratifiedSampleSize(strata = NULL, x = NULL, conf.level = 0.95,
  error = 0.1)
}
\arguments{
\item{strata}{\code{\link{vector}}, \code{\link{matrix}} or \code{\link{data.frame}}. If vector, named elements represent the size of the strata. If matrix or data.frame, first column represent the size of each strata, second column represent the expected mean in each strata and third column represent the expected variance in each strata. Each row is a strata and must be named.}

\item{x}{\code{\link{data.frame}} representing a pilot sample. First column has the variable to be estimated and second column has the strata membership of each observation. Needed when \code{strata} is a vector.}

\item{conf.level}{the confidence level required. It must be \code{\link{numeric}} between 0 and 1 inclusive.}

\item{error}{the maximum relative difference between the estimate and the unknown population value. It must be \code{\link{numeric}} between 0 and 1 inclusive.}
}
\value{
numeric sample size rounded up to nearest integer.
}
\description{
Calculates sample size to estimate a total from a stratified random sampling design.
}
\examples{
# Using a pilot sample from a population with 10000 sampling units.
strata <- rep(c("rural", "urban"), c(100, 9900))
pilot <- data.frame(c(rpois(5, 1.3), rpois(45, 0.8)),
                           rep(c("rural", "urban"), c(5, 45)))
CalculateStratifiedSampleSize(strata, pilot)
      
# Using expected mean and variance for a population with
# 10000 sampling units.
str_n <- c(rural = 100, urban = 9900)
str_mean <- c(rural = 1.4, urban = 0.98)
str_var <- c(rural = 1.48, urban = 1.02)
CalculateStratifiedSampleSize(cbind(str_n, str_mean, str_var))

}
\references{
Levy P and Lemeshow S (2008). Sampling of populations: methods and applications, Fourth edition. John Wiley and Sons, Inc.

\url{http://oswaldosantos.github.io/capm}
}
