% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-char.R
\name{count.character}
\alias{count.character}
\title{Count values in a character vector}
\usage{
\method{count}{character}(x, sort = FALSE, prop = FALSE)
}
\arguments{
\item{x}{A character vector.}

\item{sort}{If \code{TRUE}, sort the result so that the most common values float
to the top.}

\item{prop}{If \code{TRUE}, compute the fraction of marginal table.}
}
\value{
A tibble of element counts
}
\description{
Method for \code{\link[dplyr:count]{dplyr::count()}}
}
\examples{
x <- sample(LETTERS)[rpois(1000, 10)]
table(x)
dplyr::count(x)
dplyr::count(x, sort = TRUE, prop = TRUE)
}
