% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_event.R
\name{ic_event}
\alias{ic_event}
\title{Create ical object from properties_core inputs}
\format{in case of start_time and end_time being character values, a format must be provided.}
\usage{
ic_event(uid = ic_guid(),
  start_time = as.POSIXct(round.POSIXt(Sys.time(), units = "hours")),
  end_time = 1, format = "\%Y-\%m-\%d \%H:\%M",
  summary = "ical event", more_properties = FALSE,
  event_properties = calendar::properties)
}
\arguments{
\item{uid}{the unique id of the event, by default generated by \code{ic_uid()}}

\item{start_time}{start time, by default the start time plus one hour}

\item{end_time}{a number representing the number of hours
after \code{start_time} or an datetime object (of class \code{POSIXct}) when
the event ends. By default set to \code{1}, meaning 1 hour after \code{start_time}.}

\item{format}{required if start_time and end_time are vectors and are not of datetime format
"\%Y-\%m-\%d \%H:\%M", you can use \code{calendar::formats} object for convenience.}

\item{summary}{short outline of the event}

\item{more_properties}{add placeholder columns for properties in addition to \code{properties_core},
dy default \code{FALSE}}

\item{event_properties}{named vector of additional properties to include. By default
These include names stored in the data object \code{properties} (a packaged dataset),
containing \code{NA}s to be subsequently populated.}
}
\value{
object of class ics
}
\description{
Create an ical event using either POSIXct type or character type with format parameters.
}
\examples{
ic_event()
s <- lubridate::ymd_h("2019-01-01 00")
ic_event(start_time = s, end_time = 3)
# also accepts this format by default, thanks to lubridate::ymd_h:
ic_event(start_time = "2019-01-01 00")
ic_event(more_properties = TRUE)
ic_event(start_time = "18-10-12", end_time = "18-10-13", format = calendar::formats$`yy-mm-dd`)
}
