% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_foreman.R
\name{foreman}
\alias{foreman}
\title{Internal: Composite-based SEM}
\usage{
foreman(
  .data                        = args_default()$.data,
  .model                       = args_default()$.model,
  .approach_cor_robust         = args_default()$.approach_cor_robust,
  .approach_nl                 = args_default()$.approach_nl,
  .approach_paths              = args_default()$.approach_paths,
  .approach_weights            = args_default()$.approach_weights,
  .conv_criterion              = args_default()$.conv_criterion,
  .disattenuate                = args_default()$.disattenuate,
  .dominant_indicators         = args_default()$.dominant_indicators,
  .estimate_structural         = args_default()$.estimate_structural,
  .id                          = args_default()$.id,
  .instruments                 = args_default()$.instruments,
  .iter_max                    = args_default()$.iter_max,
  .normality                   = args_default()$.normality,
  .PLS_approach_cf             = args_default()$.PLS_approach_cf,
  .PLS_ignore_structural_model = args_default()$.PLS_ignore_structural_model,
  .PLS_modes                   = args_default()$.PLS_modes,
  .PLS_weight_scheme_inner     = args_default()$.PLS_weight_scheme_inner,
  .reliabilities               = args_default()$.reliabilities,
  .starting_values             = args_default()$.starting_values,
  .tolerance                   = args_default()$.tolerance
  )
}
\arguments{
\item{.data}{A \code{data.frame} or a \code{matrix} of standardized or unstandardized
data (indicators/items/manifest variables). Possible column types or classes
of the data provided are: "\code{logical}", "\code{numeric}" ("\code{double}" or "\code{integer}"),
"\code{factor}" ("\code{ordered}" and/or "\code{unordered}"), "\code{character}" (converted to factor),
or a mix of several types.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax}
or a \link{cSEMModel} list.}

\item{.approach_cor_robust}{Character string. Approach used to obtain a robust
indicator correlation matrix. One of: "\emph{none}" in which case the standard
Bravais-Person correlation is used,
"\emph{spearman}" for the Spearman rank correlation, or
"\emph{mcd}" via \code{\link[MASS:cov.rob]{MASS::cov.rob()}} for a robust correlation matrix.
Defaults to "\emph{none}". Note that many postestimation procedures (such as
\code{\link[=testOMF]{testOMF()}} or \code{\link[=fit]{fit()}} implicitly assume a continuous
indicator correlation matrix (e.g. Bravais-Pearson correlation matrix).
Only use if you know what you are doing.}

\item{.approach_nl}{Character string. Approach used to estimate nonlinear
structural relationships. One of: "\emph{sequential}" or "\emph{replace}".
Defaults to "\emph{sequential}".}

\item{.approach_paths}{Character string. Approach used to estimate the
structural coefficients. One of: "\emph{OLS}" or "\emph{2SLS}". If "\emph{2SLS}", instruments
need to be supplied to \code{.instruments}. Defaults to "\emph{OLS}".}

\item{.approach_weights}{Character string. Approach used to
obtain composite weights. One of: "\emph{PLS-PM}", "\emph{SUMCORR}", "\emph{MAXVAR}",
"\emph{SSQCORR}", "\emph{MINVAR}", "\emph{GENVAR}", "\emph{GSCA}", "\emph{PCA}", "\emph{unit}", "\emph{bartlett}",
or "\emph{regression}". Defaults to "\emph{PLS-PM}".}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.disattenuate}{Logical. Should composite/proxy correlations
be disattenuated to yield consistent loadings and path estimates if at least
one of the construct is modeled as a common factor? Defaults to \code{TRUE}.}

\item{.dominant_indicators}{A character vector of \code{"construct_name" = "indicator_name"} pairs,
where \code{"indicator_name"} is a character string giving the name of the dominant indicator
and \code{"construct_name"} a character string of the corresponding construct name.
Dominant indicators may be specified for a subset of the constructs.
Default to \code{NULL}.}

\item{.estimate_structural}{Logical. Should the structural coefficients
be estimated? Defaults to \code{TRUE}.}

\item{.id}{Character string or integer. A character string giving the name or
an integer of the position of the column of \code{.data} whose levels are used
to split \code{.data} into groups. Defaults to \code{NULL}.}

\item{.instruments}{A named list of vectors of instruments. The names
of the list elements are the names of the dependent (LHS) constructs of the structural
equation whose explanatory variables are endogenous. The vectors
contain the names of the instruments corresponding to each equation. Note
that exogenous variables of a given equation \strong{must} be supplied as
instruments for themselves. Defaults to \code{NULL}.}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.normality}{Logical. Should joint normality of
\eqn{[\eta_{1:p}; \zeta; \epsilon]}{[\eta_(1:p); \zeta; \epsilon]}
be assumed in the nonlinear model? See \insertCite{Dijkstra2014}{cSEM} for details.
Defaults to \code{FALSE}. Ignored if the model is not nonlinear.}

\item{.PLS_approach_cf}{Character string. Approach used to obtain the correction
factors for PLSc. One of: "\emph{dist_squared_euclid}", "\emph{dist_euclid_weighted}",
"\emph{fisher_transformed}", "\emph{mean_arithmetic}", "\emph{mean_geometric}", "\emph{mean_harmonic}",
"\emph{geo_of_harmonic}". Defaults to "\emph{dist_squared_euclid}".
Ignored if \code{.disattenuate = FALSE} or if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_ignore_structural_model}{Logical. Should the structural model be ignored
when calculating the inner weights of the PLS-PM algorithm? Defaults to \code{FALSE}.
Ignored if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_modes}{Either a named list specifying the mode that should be used for
each construct in the form \code{"construct_name" = mode}, a single character
string giving the mode that should be used for all constructs, or \code{NULL}.
Possible choices for \code{mode} are: "\emph{modeA}", "\emph{modeB}", "\emph{modeBNNLS}",
"\emph{unit}", "\emph{PCA}", a single integer or
a vector of fixed weights of the same length as there are indicators for the
construct given by \code{"construct_name"}. If only a single number is provided this is identical to
using unit weights, as weights are rescaled such that the related composite
has unit variance.  Defaults to \code{NULL}.
If \code{NULL} the appropriate mode according to the type
of construct used is chosen. Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.PLS_weight_scheme_inner}{Character string. The inner weighting scheme
used by PLS-PM. One of: "\emph{centroid}", "\emph{factorial}", or "\emph{path}".
Defaults to "\emph{path}". Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.reliabilities}{A character vector of \code{"name" = value} pairs,
where \code{value} is a number between 0 and 1 and \code{"name"} a character string
of the corresponding construct name, or \code{NULL}. Reliabilities
may be given for a subset of the constructs. Defaults to \code{NULL} in which case
reliabilities are estimated by \code{csem()}. Currently, only supported for
\code{.approach_weights = "PLS-PM"}.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\description{
The central hub of the \pkg{cSEM} package. It acts like a
foreman by collecting all (estimation) tasks, distributing them to lower
level package functions, and eventually recollecting all of their results.
It is called by \code{\link[=csem]{csem()}} to manage the actual calculations.
It may be called directly by the user, however, in most cases it will likely
be more convenient to use \code{\link[=csem]{csem()}} instead.
}
\seealso{
\link{csem}, \link{cSEMResults}
}
\keyword{internal}
