% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{log_likelihood2}
\alias{log_likelihood2}
\title{Calculate the negative log-likelihood for a beta-binomial regression model}
\usage{
log_likelihood2(params, X, Z, y, n, weights = NULL)
}
\arguments{
\item{params}{A numeric vector containing all model parameters. The first n_alpha elements
are coefficients for the alpha model, and the remaining elements are
coefficients for the beta model.}

\item{X}{A matrix of predictors for the alpha model.}

\item{Z}{A matrix of predictors for the beta model.}

\item{y}{A numeric vector of response values.}

\item{n}{The maximum score (number of trials in the beta-binomial distribution).}

\item{weights}{A numeric vector of weights for each observation. If NULL, equal weights are used.}
}
\value{
The negative log-likelihood of the model.
}
\description{
This function computes the negative log-likelihood for a beta-binomial regression model
where both the alpha and beta parameters are modeled as functions of predictors.
}
\details{
This function uses a numerically stable implementation of the beta-binomial log-probability.
It allows for weighted observations, which can be useful for various modeling scenarios.
}
\keyword{internal}
