% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_multi.R
\name{pairwise_multi}
\alias{pairwise_multi}
\title{Calculates multiple scores}
\usage{
pairwise_multi(
  d,
  scores = c("pair_cor", "pair_spearman", "pair_dcor", "pair_mine", "pair_ace",
    "pair_cancor", "pair_nmi", "pair_uncertainty", "pair_chi"),
  handle.na = TRUE,
  warnings = TRUE
)
}
\arguments{
\item{d}{dataframe}

\item{scores}{a character vector naming functions returning a \code{pairwise} from a dataset.}

\item{handle.na}{If TRUE uses pairwise complete observations to calculate pairwise score, otherwise NAs not handled.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}
}
\value{
tibble of class "pairwise"
}
\description{
Calculates multiple scores for every variable pair in a dataset.
}
\examples{
iris1 <- iris
iris1$Sepal.Length <- cut(iris1$Sepal.Length,3)
pairwise_multi(iris1)
}
