% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_gkGamma}
\alias{pair_gkGamma}
\title{Goodman Kruskal's Gamma for association between ordinal factors.}
\usage{
pair_gkGamma(d, handle.na = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{ignored. Pairwise complete observations are used automatically.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with factor variable pairs and Goodman Kruskal's Gamma coefficient,
or NULL if there are not at least two factor variables
}
\description{
Calculates Goodman Kruskal's Gamma coefficient for every factor variable pair in a dataset.
}
\details{
The Goodman Kruskal's Gamma coefficient is calculated using \code{\link[DescTools]{GoodmanKruskalGamma}}
function from the \code{DescTools} package. Assumes factor levels are in the given order.
NAs are automatically handled by pairwise omit.
}
\examples{
 pair_gkGamma(iris)
}
