% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Forecasts}
\alias{summary.Forecasts}
\title{Provides posterior summary of Forecasts}
\usage{
\method{summary}{Forecasts}(object, ...)
}
\arguments{
\item{object}{an object of class Forecasts obtained using the
\code{forecast()} function containing draws the predictive density.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 
5 and 95 percentiles of the forecasts for each of the variables and forecast 
horizons.
}
\description{
Provides posterior summary of the forecasts including their 
mean, standard deviations, as well as 5 and 95 percentiles.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20, thin = 1)

# forecast
fore           = forecast(posterior, horizon = 2)
fore_summary   = summary(fore)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  forecast(horizon = 2) |>
  summary() -> fore_summary

}
\seealso{
\code{\link{forecast}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
