% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nav-update.R
\name{nav_select}
\alias{nav_select}
\alias{nav_insert}
\alias{nav_remove}
\alias{nav_show}
\alias{nav_hide}
\title{Dynamically update nav containers}
\usage{
nav_select(id, selected = NULL, session = get_current_session())

nav_insert(
  id,
  nav,
  target = NULL,
  position = c("after", "before"),
  select = FALSE,
  session = get_current_session()
)

nav_remove(id, target, session = get_current_session())

nav_show(id, target, select = FALSE, session = get_current_session())

nav_hide(id, target, session = get_current_session())
}
\arguments{
\item{id}{a character string used to identify the nav container.}

\item{selected}{a character string used to identify a particular
\code{\link[=nav_panel]{nav_panel()}} item.}

\item{session}{a shiny session object (the default should almost always be used).}

\item{nav}{a \code{\link[=nav_panel]{nav_panel()}} item.}

\item{target}{The \code{value} of an existing \code{nav_panel()} item, next to which tab will be added. If removing: the \code{value} of the \code{nav_panel()} item that you want to remove.}

\item{position}{Should \code{nav} be added before or after the target?}

\item{select}{Should \code{nav} be selected upon being inserted?}
}
\description{
Functions for dynamically updating nav containers (e.g., select, insert, and
remove nav items). These functions require an \code{id} on the nav container to be
specified and must be called within an active Shiny session.
}
\examples{

can_browse <- function() interactive() && require("shiny")

# Selecting a tab
if (can_browse()) {
  shinyApp(
    page_fluid(
      radioButtons("item", "Choose", c("A", "B")),
      navset_hidden(
        id = "container",
        nav_panel_hidden("A", "a"),
        nav_panel_hidden("B", "b")
      )
    ),
    function(input, output) {
      observe(nav_select("container", input$item))
    }
  )
}

# Inserting and removing
if (can_browse()) {
  ui <- page_fluid(
    actionButton("add", "Add 'Dynamic' tab"),
    actionButton("remove", "Remove 'Foo' tab"),
    navset_tab(
      id = "tabs",
      nav_panel("Hello", "hello"),
      nav_panel("Foo", "foo"),
      nav_panel("Bar", "bar tab")
    )
  )
  server <- function(input, output) {
    observeEvent(input$add, {
      nav_insert(
        "tabs", target = "Bar", select = TRUE,
        nav_panel("Dynamic", "Dynamically added content")
      )
    })
    observeEvent(input$remove, {
      nav_remove("tabs", target = "Foo")
    })
  }
  shinyApp(ui, server)
}

}
\seealso{
\code{\link[=nav_panel]{nav_panel()}}, \code{\link[=navset_tab]{navset_tab()}}.
}
