% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCglmm_tidiers.R
\name{stdranef}
\alias{stdranef}
\title{Extract standard deviation of "random" effects from an \code{MCMCglmm} object}
\usage{
stdranef(object, which, type = c("lp", "response"), ...)
}
\arguments{
\item{object}{An \code{MCMCglmm} model object to extract the effects from}

\item{which}{A list of random effects to extract or their numeric positions
If there are two numbers in a list, effects are simulataneous.}

\item{type}{A character string indicating whether to calculate the standard
deviation on the linear predictor metric, \sQuote{lp} or
response, \sQuote{response}.}

\item{\dots}{Not currently used.}
}
\value{
A list of class postMCMCglmmRE with means (\code{M}) and individual estimates (\code{Data})
}
\description{
Function designed to extract the standard deviation of the
random effects from an \code{MCMCglmm} model object.
Note that this is not the same as the posterior distribution of
(co)variance matrices. It is based on the posterior distribution
of the random effects. This also means it requires \code{pr=TRUE}
to be set in the model for the information to be saved. Can optionally
return standard deviation of random effects after back transforming to
the response metric. Currently probabilities, but only for ordinal family
models (\code{family="ordinal"}).
}
\examples{
\dontrun{
  # a simple MCMCglmm model
  data(PlodiaPO)
  PlodiaPO <- within(PlodiaPO, {
    PO2 <- cut(PO, quantile(PO, c(0, .33, .66, 1)))
    plate <- factor(plate)
  })

  m <- MCMCglmm(PO2 ~ 1, random = ~ FSfamily + plate,
    family = "ordinal", data = PlodiaPO,
    prior = list(
      R = list(V = 1, fix = 1),
      G = list(
        G1 = list(V = 1, nu = .002),
        G2 = list(V = 1, nu = .002)
      )
    ), verbose=FALSE, thin=1, pr=TRUE)

  # summary of the model
  summary(m)

  # examples of extracting standard deviations of
  # different random effects on the linear predictor metric
  # or after transformation to probabilities (only for ordinal)
  stdranef(m, which = list(1), type = "lp")
  stdranef(m, which = list(2), type = "lp")
  stdranef(m, which = list(1, 2, c(1, 2)), type = "lp")
  stdranef(m, type = "lp")

  ## error because no 3rd random effect
  #stdranef(m, which = list(1, 2, 3), type = "lp")

  stdranef(m, which = list("FSfamily", "plate"), type = "lp")

  # mean standard deviations on the probability metric
  # also the full distributions, if desired in the Data slot.
  res <- stdranef(m, type = "response")
  res$M # means
  hist(res$Data$FSfamily[, 1]) # histogram
}
}
