% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy_ggpredict}
\alias{tidy_ggpredict}
\title{Conditional Effects Estimation}
\usage{
tidy_ggpredict(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a model}

\item{conf.int}{logical indicating whether or not to include a confidence
interval in the tidied output}

\item{conf.level}{the confidence level to use for the confidence interval}

\item{...}{additional parameters passed to \code{ggeffects::ggpredict()}}
}
\description{
Use \code{ggeffects::ggpredict()} to estimate "conditional effects" and return a
tibble tidied in a way that could be used by \code{broom.helpers}functions.
See \url{https://strengejacke.github.io/ggeffects/} for a list of supported
models.
}
\examples{
df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, weights = df$n, family = binomial
)
tidy_ggpredict(mod)
tidy_plus_plus(mod, tidy_fun = tidy_ggpredict)
}
\seealso{
\code{ggeffects::ggpredict()}

Other custom_tieders: 
\code{\link{tidy_all_effects}()},
\code{\link{tidy_broom}()},
\code{\link{tidy_margins}()},
\code{\link{tidy_multgee}()},
\code{\link{tidy_parameters}()},
\code{\link{tidy_with_broom_or_parameters}()}
}
\concept{custom_tieders}
