% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_variables.R
\name{model_list_variables}
\alias{model_list_variables}
\alias{model_list_variables.default}
\alias{model_list_variables.lavaan}
\title{List all the variables used in a model}
\usage{
model_list_variables(model)

\method{model_list_variables}{default}(model)

\method{model_list_variables}{lavaan}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with three columns:
\itemize{
\item \code{variable}: the corresponding variable
\item \code{var_class}: class of the variable (cf. \code{\link[stats:checkMFClasses]{stats::.MFclass()}})
\item \code{label_attr}: variable label defined in the original data frame
with the label attribute (cf. \code{\link[labelled:var_label]{labelled::var_label()}})
}
}
\description{
Including variables used only in an interaction.
}
\examples{
Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes"))) \%>\%
  glm(
    Survived ~ Class + Age : Sex,
    data = ., weights = .$n,
    family = binomial
  ) \%>\%
  model_list_variables()

iris \%>\%
  lm(
    Sepal.Length ~ poly(Sepal.Width, 2) + Species,
    data = .,
    contrasts = list(Species = contr.sum)
  ) \%>\%
  model_list_variables()

if (requireNamespace("gtsummary")) {
  glm(
    response ~ poly(age, 3) + stage + grade * trt,
    na.omit(gtsummary::trial),
    family = binomial,
  ) \%>\%
    model_list_variables()
}
}
\seealso{
Other model_helpers: 
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()}
}
\concept{model_helpers}
