% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotonics.R
\name{monotonic}
\alias{monotonic}
\alias{increasing}
\alias{decreasing}
\alias{unvarying}
\title{Are values monotonic? Always increasing, decreasing, or unvarying?}
\usage{
increasing(x, ...)

decreasing(x, ...)

unvarying(x, ...)

monotonic(x, ...)
}
\arguments{
\item{x}{numeric or integer}

\item{...}{extra arguments to pass to diff}
}
\value{
logical TRUE or FALSE
}
\description{
These provides three families of functions to tell you if values are always
increasing, decreasing, or unvarying, with the functions, \code{increasing()},
\code{decreasing()}, or \code{unvarying()}. Under the hood it uses \code{diff} to find
differences, so if you like you can pass extra arguments to \code{diff}.
}
\examples{
vec_inc <- c(1:10)
vec_dec<- c(10:1)
vec_ran <- c(sample(1:10))
vec_flat <- rep.int(1,10)

increasing(vec_inc)
increasing(vec_dec)
increasing(vec_ran)
increasing(vec_flat)

decreasing(vec_inc)
decreasing(vec_dec)
decreasing(vec_ran)
decreasing(vec_flat)

unvarying(vec_inc)
unvarying(vec_dec)
unvarying(vec_ran)
unvarying(vec_flat)

library(ggplot2)
library(gghighlight)
library(dplyr)

heights_mono <- heights \%>\%
  features(height_cm, feat_monotonic) \%>\%
  left_join(heights, by = "country")
  
  ggplot(heights_mono,
         aes(x = year,
             y = height_cm,
             group = country)) +
  geom_line() + 
  gghighlight(increase)

 ggplot(heights_mono,
        aes(x = year,
            y = height_cm,
             group = country)) +
  geom_line() + 
  gghighlight(decrease)

heights_mono \%>\%
filter(monotonic) \%>\%
  ggplot(aes(x = year,
             y = height_cm,
             group = country)) + 
  geom_line()
  
heights_mono \%>\%
  filter(increase) \%>\%
  ggplot(aes(x = year,
             y = height_cm,
             group = country)) + 
  geom_line()
  
}
