% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-sample.R
\name{facet_sample}
\alias{facet_sample}
\title{Facet data into groups to facilitate exploration}
\usage{
facet_sample(
  n_per_facet = 3,
  n_facets = 12,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  shrink = TRUE,
  strip.position = "top"
)
}
\arguments{
\item{n_per_facet}{Number of keys per facet you want to plot. Default is 3.}

\item{n_facets}{Number of facets to create. Default is 12}

\item{nrow}{Number of rows and columns.}

\item{ncol}{Number of rows and columns.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\value{
a ggplot object
}
\description{
This function requires a \code{tbl_ts} object, which can be created with
\code{tsibble::as_tsibble()}. Under the hood, \code{facet_strata} is powered by
\code{\link[=stratify_keys]{stratify_keys()}} and \code{\link[=sample_n_keys]{sample_n_keys()}}.
}
\examples{
library(ggplot2)
ggplot(heights,
aes(x = year,
    y = height_cm,
    group = country)) +
  geom_line() +
  facet_sample()

ggplot(heights,
       aes(x = year,
           y = height_cm,
           group = country)) +
  geom_line() +
  facet_sample(n_per_facet = 1,
               n_facets = 12)
}
