% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{predict.brmsfit}
\alias{predict.brmsfit}
\alias{posterior_predict.brmsfit}
\alias{posterior_predict}
\title{Model Predictions of \code{brmsfit} Objects}
\usage{
\method{predict}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  transform = NULL, allow_new_levels = FALSE,
  sample_new_levels = "uncertainty", new_objects = list(),
  incl_autocor = TRUE, resp = NULL, negative_rt = FALSE,
  subset = NULL, nsamples = NULL, sort = FALSE, nug = NULL,
  ntrys = 5, summary = TRUE, robust = FALSE, probs = c(0.025,
  0.975), ...)

\method{posterior_predict}{brmsfit}(object, newdata = NULL,
  re_formula = NULL, re.form = NULL, transform = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  new_objects = list(), incl_autocor = TRUE, resp = NULL,
  negative_rt = FALSE, subset = NULL, nsamples = NULL,
  sort = FALSE, nug = NULL, ntrys = 5, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{transform}{A function or a character string naming 
a function to be applied on the predicted responses
before summary statistics are computed.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{negative_rt}{Only relevant for Wiener diffusion models. 
A flag indicating whether response times of responses
on the lower boundary should be returned as negative values.
This allows to distinguish responses on the upper and
lower boundary. Defaults to \code{FALSE}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{ntrys}{Parameter used in rejection sampling 
for truncated discrete models only 
(defaults to \code{5}). See Details for more information.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Currently ignored.}

\item{re.form}{Alias of \code{re_formula}.}
}
\value{
Predicted values of the response variable. 
  If \code{summary = TRUE} the output depends on the family:
  For categorical and ordinal families, it is a N x C matrix, 
  where N is the number of observations and
  C is the number of categories. 
  For all other families, it is a N x E matrix where E is equal 
  to \code{length(probs) + 2}.
  If \code{summary = FALSE}, the output is as a S x N matrix, 
  where S is the number of samples.
  In multivariate models, the output is an array of 3 dimensions, 
  where the third dimension indicates the response variables.
}
\description{
Predict responses based on the fitted model.
Can be performed for the data used to fit the model 
(posterior predictive checks) or for new data.
By definition, these predictions have higher variance than 
predictions of the fitted values (i.e., the 'regression line')
performed by the \code{\link[brms:fitted.brmsfit]{fitted}}
method. This is because the measurement error is incorporated.
The estimated means of both methods should, however, be very similar.
}
\details{
\code{NA} values within factors in \code{newdata}, 
  are interpreted as if all dummy variables of this factor are 
  zero. This allows, for instance, to make predictions of the grand mean 
  when using sum coding.  
  
  Method \code{posterior_predict.brmsfit} is an alias of 
  \code{predict.brmsfit} with \code{summary = FALSE}. 

  For truncated discrete models only:
  In the absence of any general algorithm to sample 
  from truncated discrete distributions,
  rejection sampling is applied in this special case. 
  This means that values are sampled until 
  a value lies within the defined truncation boundaries. 
  In practice, this procedure may be rather slow (especially in \R). 
  Thus, we try to do approximate rejection sampling 
  by sampling each value \code{ntrys} times and then select a valid value. 
  If all values are invalid, the closest boundary is used, instead. 
  If there are more than a few of these pathological cases, 
  a warning will occur suggesting to increase argument \code{ntrys}.
}
\examples{
\dontrun{
## fit a model
fit <- brm(time | cens(censored) ~ age + sex + (1+age||patient), 
           data = kidney, family = "exponential", inits = "0")

## predicted responses
pp <- predict(fit)
head(pp)

## predicted responses excluding the group-level effect of age
pp2 <- predict(fit, re_formula = ~ (1|patient))
head(pp2)

## predicted responses of patient 1 for new data
newdata <- data.frame(sex = factor(c("male", "female")),
                      age = c(20, 50),
                      patient = c(1, 1))
predict(fit, newdata = newdata)
}

}
