% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{lasso}
\alias{lasso}
\title{Set up a lasso prior in \pkg{brms}}
\usage{
lasso(df = 1, scale = 1)
}
\arguments{
\item{df}{Degrees of freedom of the chi-sqaure prior of the inverse tuning
parameter. Defaults to \code{1}.}

\item{scale}{Scale of the lasso prior. Defaults to \code{1}.}
}
\value{
A character string obtained by \code{match.call()} with
  additional arguments.
}
\description{
Function used to set up a lasso prior for population-level effects 
in \pkg{brms}. The function does not evaluate its arguments --
it exists purely to help set up the model.
}
\details{
See \code{\link[brms:set_prior]{set_prior}} for more details
  about the lasso prior.
}
\examples{
set_prior(lasso(df = 1, scale = 10))

}
\seealso{
\code{\link[brms:set_prior]{set_prior}}
}

