% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{predict.brmsfit}
\alias{predict.brmsfit}
\title{Model Predictions of \code{brmsfit} Objects}
\usage{
\method{predict}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  transform = NULL, allow_new_levels = FALSE, subset = NULL,
  nsamples = NULL, ntrys = 5, summary = TRUE, probs = c(0.025, 0.975),
  ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{re_formula}{formula containing random effects 
to be considered in the prediction. 
If \code{NULL} (default), include all random effects; 
if \code{NA}, include no random effects.}

\item{transform}{A function or a character string naming 
a function to be applied on the predicted responses
before summary statistics are computed.}

\item{allow_new_levels}{A flag indicating if new
levels of random effects are allowed (defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{ntrys}{Parameter used in rejection sampling 
for truncated discrete models only 
(defaults to \code{5}). See Details for more information.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{probs}{The percentiles to be computed 
by the \code{quantile} function. 
Only used if \code{summary} is \code{TRUE}.}

\item{...}{Currently ignored}
}
\value{
Predicted values of the response variable. 
  If \code{summary = TRUE} the output depends on the family:
  For catagorical and ordinal families, it is a N x C matrix, 
  where N is the number of observations and
  C is the number of categories. 
  For all other families, it is a N x E matrix where E is equal 
  to \code{length(probs) + 2}.
  If \code{summary = FALSE}, the output is as a S x N matrix, 
  where S is the number of samples.
}
\description{
Predict responses based on the fitted model.
Can be performed for the data used to fit the model 
(posterior predictive checks) or for new data.
By definition, these predictions have higher variance than 
predictions of the fitted values (i.e. the 'regression line')
performed by the \code{\link[brms:fitted.brmsfit]{fitted}}
method. This is because the measurement error is incorporated.
The estimated means of both methods should, however, be very similar.
}
\details{
\code{NA} values within factors in \code{newdata}, 
  are interpreted as if all dummy variables of this factor are 
  zero. This allows, for instance, to make predictions of the grand mean 
  when using sum coding.  

  For truncated discrete models only:
  In the absence of any general algorithm to sample 
  from truncated discrete distributions,
  rejection sampling is applied in this special case. 
  This means that values are sampled until 
  a value lies within the defined truncation boundaries. 
  In practice, this procedure may be rather slow (especially in R). 
  Thus, we try to do approximate rejection sampling 
  by sampling each value \code{ntrys} times and then select a valid value. 
  If all values are invalid, the closest boundary is used, instead. 
  If there are more than a few of these pathological cases, 
  a warning will occure suggesting to increase argument \code{ntrys}.
  
  For models fitted with \pkg{brms} <= 0.5.0 only: 
  Be careful when using \code{newdata} with factors 
  in fixed or random effects. The predicted results are only valid 
  if all factor levels present in the initial 
  data are also defined and ordered correctly 
  for the factors in \code{newdata}.
  Grouping factors may contain fewer levels than in the 
  inital data without causing problems.
  When using higher versions of \pkg{brms}, 
  all factors are automatically checked 
  for correctness and amended if necessary.
}
\examples{
\dontrun{
## fit a model
fit <- brm(time | cens(censored) ~ age + sex + (1+age||patient), 
           data = kidney, family = "exponential", inits = "0")

## predicted responses
pp <- predict(fit)
head(pp)

## predicted responses excluding the random effect of age
pp2 <- predict(fit, re_formula = ~ (1|patient))
head(pp2)

## predicted responses of patient 1 for new data
newdata <- data.frame(sex = factor(c("male", "female")),
                      age = c(20, 50),
                      patient = c(1, 1))
predict(fit, newdata = newdata)
}

}

