% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_model.R
\name{brm_model}
\alias{brm_model}
\title{Fit an MMRM.}
\usage{
brm_model(
  data,
  formula,
  ...,
  prior = NULL,
  family = brms::brmsfamily(family = "gaussian"),
  imputed = NULL
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.
Unless you supplied \code{model_missing_outcomes = TRUE} in \code{\link[=brm_formula]{brm_formula()}},
\code{\link[=brm_model]{brm_model()}} automatically rows with missing outcomes
just prior to fitting the model with \code{\link[brms:brm]{brms::brm()}}.
The \code{brms.mmrm_data} attribute
in the output object is always the version of the data prior to
removing these rows. See the \code{data} element of the returned \code{brms}
object for the final data actually supplied to the model.

If you supply a non-\code{NULL} value for the \code{imputed}
argument, then the \code{data} argument is ignored and the MMRM is fit
successively to each dataset in \code{imputed} using \code{\link[brms:brm_multiple]{brms::brm_multiple()}}.
Posterior draws are combined automatically for downstream post-processing
unless you set \code{combine = FALSE} in \code{\link[=brm_model]{brm_model()}}.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full mapping
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{...}{Arguments to \code{\link[brms:brm]{brms::brm()}} or \code{\link[brms:brm_multiple]{brms::brm_multiple()}}
other than \code{data}, \code{formula}, \code{prior}, and \code{family}.}

\item{prior}{Either \code{NULL} for default priors
or a \code{"brmsprior"} object from \code{brms::prior()}.}

\item{family}{A \code{brms} family object generated by \code{\link[brms:brmsfamily]{brms::brmsfamily()}}.
Must fit a continuous outcome variable and have the identity link.}

\item{imputed}{Either \code{NULL} (default), list of
datasets generated with multiple imputation, or a \code{"mids"} object
from the \code{mice} package. The \code{rbmi} package may offer a more appropriate
method for imputation for MMRMs than \code{mice}. It is your responsibility
to choose an imputation method appropriate for the data and model.

If not \code{NULL}, then the MMRM is fit
successively to each dataset in \code{imputed} using \code{\link[brms:brm_multiple]{brms::brm_multiple()}}.
Posterior draws are combined automatically for downstream post-processing
unless you set \code{combine = FALSE} in \code{\link[=brm_model]{brm_model()}}, so everything at
the level of \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} will be exactly the same as
a non-imputation workflow.

Even if you supply \code{imputed}, please also supply the original
non-imputed dataset in the \code{data} argument to help with
downstream post-processing.}
}
\value{
A fitted model object from \code{brms}, with new list elements
\code{brms.mmrm_data} and \code{brms.mmrm_formula} to capture the data
and formula supplied to \code{\link[=brm_model]{brm_model()}}. See the explanation of the
\code{data} argument for how the data is handled and how it relates
to the data returned in the \code{brms.mmrm_data} attribute.
}
\description{
Fit an MMRM model using \code{brms}.
}
\section{Parameterization}{

For a formula on a \code{\link[=brm_data]{brm_data()}} dataset,
the formula is not the only factor
that determines the fixed effect mapping.
The ordering of the categorical variables in the data,
as well as the \code{contrast} option in R, affect the
construction of the model matrix. To see the model
matrix that will ultimately be used in \code{\link[=brm_model]{brm_model()}},
run \code{\link[brms:standata]{brms::make_standata()}} and examine the \code{X} element
of the returned list. See the examples below for a
demonstration.
}

\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
# Optional: set the contrast option, which determines the model matrix.
options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
# See the fixed effect mapping you get from the data:
head(brms::make_standata(formula = formula, data = data)$X)
# Specify a different contrast method to use an alternative
# mapping when fitting the model with brm_model():
options(
  contrasts = c(unordered = "contr.treatment", ordered = "contr.poly")
)
# different model matrix than before:
head(brms::make_standata(formula = formula, data = data)$X)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
# The output is a brms model fit object with added list
# elements "brms.mmrm_data" and "brms.mmrm_formula" to track the dataset
# and formula used to fit the model.
model$brms.mmrm_data
model$brms.mmrm_formula
# Otherwise, the fitted model object acts exactly like a brms fitted model.
suppressWarnings(print(model))
brms::prior_summary(model)
}
}
\seealso{
Other models: 
\code{\link{brm_formula}()},
\code{\link{brm_formula_sigma}()}
}
\concept{models}
