% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{db_cluster_events}
\alias{db_cluster_events}
\title{List Cluster Activity Events}
\usage{
db_cluster_events(
  cluster_id,
  start_time = NULL,
  end_time = NULL,
  event_types = NULL,
  order = c("DESC", "ASC"),
  offset = 0,
  limit = 50,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{The ID of the cluster to retrieve events about.}

\item{start_time}{The start time in epoch milliseconds. If empty, returns
events starting from the beginning of time.}

\item{end_time}{The end time in epoch milliseconds. If empty, returns events
up to the current time.}

\item{event_types}{List. Optional set of event types to filter by. Default
is to return all events. \href{https://docs.databricks.com/api/workspace/clusters/events#events}{Event Types}.}

\item{order}{Either \code{DESC} (default) or \code{ASC}.}

\item{offset}{The offset in the result set. Defaults to 0 (no offset). When
an offset is specified and the results are requested in descending order, the
end_time field is required.}

\item{limit}{Maximum number of events to include in a page of events.
Defaults to 50, and maximum allowed value is 500.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List Cluster Activity Events
}
\details{
Retrieve a list of events about the activity of a cluster. You can retrieve
events from active clusters (running, pending, or reconfiguring) and
terminated clusters within 30 days of their last termination. This API is
paginated. If there are more events to read, the response includes all the
parameters necessary to request the next page of events.
}
\seealso{
Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_edit}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_start}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_and_start_cluster}()},
\code{\link{get_latest_dbr}()}
}
\concept{Clusters API}
