% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request-helpers.R
\name{db_request}
\alias{db_request}
\title{Databricks Request Helper}
\usage{
db_request(endpoint, method, version = NULL, body = NULL, host, token, ...)
}
\arguments{
\item{endpoint}{Databricks REST API Endpoint}

\item{method}{Passed to \code{\link[httr2:req_method]{httr2::req_method()}}}

\item{version}{String, API version of endpoint. E.g. \code{2.0}.}

\item{body}{Named list, passed to \code{\link[httr2:req_body]{httr2::req_body_json()}}.}

\item{host}{Databricks host, defaults to \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks token, defaults to \code{\link[=db_token]{db_token()}}.}

\item{...}{Parameters passed on to \code{\link[httr2:req_body]{httr2::req_body_json()}} when \code{body} is not \code{NULL}.}
}
\value{
request
}
\description{
Databricks Request Helper
}
\seealso{
Other Request Helpers: 
\code{\link{db_perform_request}()},
\code{\link{db_req_error_body}()},
\code{\link{db_request_json}()}
}
\concept{Request Helpers}
