% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break.R
\name{broken.ranger}
\alias{broken.ranger}
\title{Create the broken object for ranger models}
\usage{
\method{broken}{ranger}(model, new_observation, ..., baseline = 0)
}
\arguments{
\item{model}{a ranger model}

\item{new_observation}{a new observation with collumns that corresponds to variables used in the model}

\item{...}{other parameters}

\item{baseline}{the orgin/baseline for the breakDown plots, where the rectangles start. It may be a number or a character "Intercept". In the latter case the orgin will be set to model intercept.}
}
\value{
an object of the broken class
}
\description{
Create the broken object for ranger models
}
\examples{
\dontrun{
library("ranger")
library("ggplot2")
model <- ranger(factor(left) ~ ., data = HR_data, importance = 'impurity')
importance(model)
new_observation <- HR_data[10099,]
explain_1 <- broken(model, new_observation)
explain_1
plot(explain_1) +
   ggtitle("breakDown plot for linear predictors of leaving the company") +
   scale_y_continuous( limits = c(0,1), name = "fraction of trees", expand = c(0.1,0.1))
 }

}
