% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_brainGraph}
\alias{make_brainGraph}
\alias{summary.brainGraph}
\title{Create a brainGraph object}
\usage{
make_brainGraph(g, atlas, rand = FALSE, modality = NULL,
  weighting = NULL, threshold = NULL, subject = NULL, group = NULL)

\method{summary}{brainGraph}(object, print.attrs = c("all", "none"), ...)
}
\arguments{
\item{g}{An \emph{igraph} graph object.}

\item{atlas}{Character string specifying the brain atlas}

\item{rand}{A character string indicating whether this function is being run
for a random graph. Default: \code{FALSE}}

\item{modality}{Character vector indicating imaging modality (e.g. 'dti').
Default: \code{NULL}}

\item{weighting}{Character string indicating how the edges are weighted
(e.g., 'fa', 'pearson', etc.). Default: \code{NULL}}

\item{threshold}{Numeric indicating the level at which the matrices were
thresholded (if at all). Default: \code{NULL}}

\item{subject}{Character vector indicating subject ID. Default: \code{NULL}}

\item{group}{Character vector indicating group membership. Default:
\code{NULL}}

\item{object}{A \code{brainGraph} object}

\item{print.attrs}{Character string indicating whether or not to list the
object's attributes (default: \code{all})}

\item{...}{Unused}
}
\value{
A \code{brainGraph} graph object with additional attributes:
  \item{version}{(graph-level) The current version of \code{brainGraph}}
  \item{atlas}{(graph-level)}
  \item{lobe}{(vertex-leve) Character vector of lobe names}
  \item{hemi}{(vertex-leve) Character vector of hemispheres (\code{'L'},
    \code{'R'}, or \code{'B'})}
  \item{lobe.hemi}{Integer vector indicating the lobe and hemisphere}
  \item{class}{(vertex-leve) Character vector of class names (if applicable)}
  \item{network}{(vertex-leve) Character vector of network names (if
    applicable)}
  \item{modality}{(graph-level)}
  \item{weighting}{(graph-level)}
  \item{threshold}{(graph-level)}
  \item{name}{(graph-level) The subject ID (if specified by \code{subject})}
  \item{Group}{(graph-level) only if \code{group} is specified}
  \item{x, y, z, x.mni, y.mni, z.mni}{Spatial coordinates}
  \item{color.lobe}{(vertex- and edge-level) Colors based on \emph{lobe}}
  \item{color.class,color.network}{(vertex- and edge-level) If applicable}
  \item{circle.layout}{Integer vector for ordering the vertices for circle
    plots}
}
\description{
Create a \code{brainGraph} graph object, which is an \code{igraph} graph
object with additional attributes (at all levels). The values are dependent
on the specified brain atlas.
}
\details{
For the \code{modality} argument, you can choose anything you like, but the
\code{summary.brainGraph} knows about \code{dti}, \code{fmri},
\code{thickness}, \code{area}, and \code{volume}.

For the \code{weighting} argument, you can choose anything you like, but
\code{summary.brainGraph} knows about \code{fa}, \code{sld} (streamline
density, tractography), \code{pearson}, \code{spearman}, \code{kendall}, and
\code{partial} (partial correlation coefficient).
}
\seealso{
Other Graph creation functions: \code{\link{make_ego_brainGraph}},
  \code{\link{make_empty_brainGraph}},
  \code{\link{make_glm_brainGraph}},
  \code{\link{make_mediate_brainGraph}},
  \code{\link{make_nbs_brainGraph}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Graph creation functions}
