% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{FreesurferAtlases}
\alias{FreesurferAtlases}
\alias{destrieux}
\alias{destrieux.scgm}
\alias{dk}
\alias{dk.scgm}
\alias{dkt}
\alias{dkt.scgm}
\title{Coordinates for data from Freesurfer atlases}
\format{A data frame with 148 or 162 (for Destrieux), 68 or 82 (for DK), or
62 or 76 (for DKT) observations on the following 8 variables:
\describe{
  \item{\code{name}}{a character vector of region names}
  \item{\code{x.mni}}{a numeric vector of x-coordinates (in MNI space)}
  \item{\code{y.mni}}{a numeric vector of y-coordinates (in MNI space)}
  \item{\code{z.mni}}{a numeric vector of z-coordinates (in MNI space)}
  \item{\code{lobe}}{a factor with levels \code{Frontal}, \code{Parietal},
    \code{Temporal}, \code{Occipital}, \code{Insula}, \code{Limbic}, and
    \code{SCGM} (for atlases ending in \code{.scgm})}
  \item{\code{hemi}}{a factor with levels \code{L} \code{R}}
  \item{\code{index}}{a numeric vector}
  \item{\code{name.full}}{a character vector of full region names, for the DK
    and DKT atlases}
  \item{\code{class}}{a factor with levels \code{G} \code{G_and_S} \code{S}}
}}
\usage{
destrieux

destrieux.scgm

dk

dk.scgm

dkt

dkt.scgm
}
\description{
Datasets containing spatial coordinates for the Freesurfer atlases:
Destrieux, Desikan-Killiany (DK), and Desikan-Killiany-Tourville (DKT). The
datasets also contain indices for the major lobes and hemispheres of the
brain, in addition to the \emph{class} variable for Destrieux atlases.
}
\references{
Destrieux C., Fischl B., Dale E. \& Halgren E. (2010)
  \emph{Automatic parcellation of human cortical gyri and sulci using
  standard anatomic nomenclature}. NeuroImage, 53(1):1-15.

Desikan R.S., Segonne F., Fischl B., et al. (2006) \emph{An
  automated labeling system for subdividing the human cerebral cortex on MRI
  scans into gyral based regions of interest}. NeuroImage, 31:968-980.

Klein A. and Tourville J. (2012) \emph{101 labeled brain images
  and a consistent human cortical labeling protocol}. Front Neurosci,
  doi:10.3389/fnins.2012.00171
}
\keyword{datasets}
