% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_init.R
\name{brainGraph_init}
\alias{brainGraph_init}
\title{Initialize variables for further use in brainGraph}
\usage{
brainGraph_init(atlas, densities, datadir, modality = c("thickness", "volume",
  "lgi", "area"), covars = NULL, exclude.subs = NULL, custom.atlas = NULL)
}
\arguments{
\item{atlas}{Character string indicating which brain atlas you are using.
This can be an atlas present with the package or a custom atlas; in this
case you must specify \code{custom} here and assign the name to the
argument \code{custom.atlas}.}

\item{densities}{Numeric vector of the graph densities you would like to
investigate}

\item{datadir}{Character string; the filesystem location of your input files}

\item{modality}{Character string indicating the volumetric MRI
modality/measure used to create the graphs (default: \code{thickness})}

\item{covars}{A \code{data.table} of covariates; specify this if you do not
want to load your full covariates file (default: \code{NULL})}

\item{exclude.subs}{Character vector of the Study ID's of subjects who are to
be excluded from the analysis (default: \code{NULL})}

\item{custom.atlas}{Character string of the name of the custom atlas you wish
to use, if applicable (default: \code{NULL})}
}
\value{
A list containing:
  \item{atlas}{Character string of the brain atlas name}
  \item{densities}{Numeric vector of the graph densities}
  \item{modality}{Character string of the modality you chose}
  \item{kNumDensities}{Integer indicating the number of densities}
  \item{covars}{A \code{data.table} of covariates}
  \item{groups}{Character vector of subject group names}
  \item{kNumGroups}{Integer indicating the number of groups}
  \item{kNumVertices}{Integer; the number of vertices in the graphs}
  \item{lhrh}{A \code{data.table} of left- and right-hemispheric volumetric
    data}
}
\description{
Initializes some variables that are important for further analysis of
structural covariance networks (e.g., \emph{cortical thickness}). This mostly
involves loading CSV files (of covariates/demographics, cortical
thickness/volumes, etc.) and returning them as data tables.
}
\details{
You can use any atlas that is already present in the package; to check the
available atlases, you can type
\code{data(package="brainGraph")$results[, 3]} at the R prompt. If you have a
custom atlas, specify \code{atlas="custom"} and supply the R object's name
for the argument \code{custom.atlas}.

The file containing covariates should be named \code{covars.csv}. However,
you may also supply a \code{data.table} using the function argument
\code{covars}. This is useful if you have multiple covariates in your file
and wish to subset the data on your own.

The filenames of files containing volumetric data should include hemisphere,
atlas, and modality separated by the \emph{underscore} character, e.g.
\code{lh_dkt_thickness.csv}. If you would like to include subcortical gray
matter, then you will need files \code{covars.scgm.csv} and \code{scgm.csv}.
}
\examples{
\dontrun{
init.vars <- brainGraph_init(atlas='dkt', densities=seq(0.07, 0.50, 0.01),
  datadir='/home/cwatson/Data', modality='thickness', exclude.subs=c('Con07',
  'Con23', 'Pat15'))
}
}
\seealso{
Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{get.resid}},
  \code{\link{plot.brainGraph_resids}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
