% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{brainGraph_GLM}
\alias{brainGraph_GLM}
\title{Run linear models at each vertex of a graph}
\usage{
brainGraph_GLM(g, covars, measure, con.vec, outcome = measure, X = NULL,
  con.name = NULL, alternative = c("two.sided", "less", "greater"),
  alpha = 0.05, permute = FALSE, N = 5000, ...)
}
\arguments{
\item{g}{A list of \code{igraph} graph objects for all subjects (if you have
multiple groups, you must concatenate the separate group lists)}

\item{covars}{A \code{data.table} of covariates}

\item{measure}{A character string of the vertex measure of interest}

\item{con.vec}{A numeric vector specifying the contrast of interest}

\item{outcome}{A character string of the name of the outcome variable; by
default, it is ignored}

\item{X}{A numeric matrix, if you wish to supply your own design matrix
(default: \code{NULL})}

\item{con.name}{Character string of the contrast name (default: \code{NULL})}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: \code{'two.sided'})}

\item{alpha}{Numeric; the significance level (default: 0.05)}

\item{permute}{Logical indicating whether or not to permute group labels
(default: \code{FALSE})}

\item{N}{Integer; number of permutations to create (default: 5e3)}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}}
}
\value{
A list containing:
\item{g}{A graph with vertex attributes: \emph{size2} (t-statistic),
  \emph{size} (the t-stat transformed for visualization purposes), \emph{p}
  (equal to \eqn{1-p}), \emph{p.fdr} (equal to \eqn{1-p_{FDR}}, the
  FDR-adjusted p-value), \emph{gamma} (the contrast of parameter estimaties,
  \emph{se} (the standard error of \emph{gamma}); and graph attributes:
  \emph{df} (degrees of freedom), \emph{name} (contrast name), \emph{outcome}
  (the outcome variable)}
\item{DT}{A data table with an entry for each vertex (region)}
\item{X}{A numeric matrix; a copy of the \emph{design matrix}}
\item{perm}{A list containing: \emph{null.dist} (the null distribution of
  maximum t-statistics), \emph{thresh} (the t-statistic value corresponding
  to \eqn{100 \times (1 - \alpha)}\% of the null distribution)}
}
\description{
This function takes a list of \code{igraph} graphs and specifies a linear
model at each vertex for a given vertex measure (e.g. \emph{degree}).
}
\details{
You will need to provide a \code{data.table} of covariates, of which
\emph{Study.ID} needs to be the first column. Additionally, all graphs must
have a \emph{name} attribute (at the graph level) which matches the
\emph{Study.ID} for a given subject. If you do not provide covariates,
the code will pull group membership from the graphs' \emph{Group} attributes
and do a test of group differences. This function returns, for each region,
the contrast of parameter estimates (i.e., \eqn{\gamma}), standard error of
the contrast, t-statistic, \eqn{100 (1 - \alpha)}\% confidence interval,
p-value, and FDR-adjusted p-value.

To test whether a vertex attribute is associated with a different outcome
(e.g., \emph{betweenness centrality} and \emph{full-scale IQ}), then specify
the relevant outcome variable in the function call, and provide the data in
the covariates table.

You may optionally do permutation testing by permuting the labels for subject
group. This is the same principle as that of Nichols & Holmes (2001) used in
voxelwise MRI analyses and implemented in FSL's \emph{randomise}.
}
\examples{
\dontrun{
g.lm <- brainGraph_GLM(c(g.norm[[1]][[6]], g.norm[[2]][[6]]),
  measure='strength',
  covars=covars.all[Group == groups[2],
                    c(names(covars.dti)[-2], 'Age.Fontan'),
                    with=F]
  con.vec=c(0, 0, 0, 1))

# Test for the group diff between "Neonate" and "Non-Neonate" in nodal eff.
covars <- covars.all[Group == groups[2] & tract == 1,
  c(names(covars.dti)[-2], 'Age.op1.cat'), with=F]
covars[, Age.op1.cat := factor(Age.op1.cat)]
g.lm <- brainGraph_GLM(g.norm[[2]][[6]], measure='E.nodal.wt',
  covars=covars, con.vec=c(0, 0, 0, 0, 1))
}
}
\references{
Nichols TE & Holmes AP (2001). \emph{Nonparametric permutation
  tests for functional neuroimaging: A primer with examples.} Human Brain
  Mapping, 15(1):1-25.
}
\seealso{
Other GLM functions: \code{\link{brainGraph_GLM_design}},
  \code{\link{brainGraph_GLM_fit}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
