% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_lobes.R
\name{assign_lobes}
\alias{assign_lobes}
\title{Give vertices in a graph a \emph{lobe} attribute.}
\usage{
assign_lobes(g, rand = FALSE)
}
\arguments{
\item{g}{An \emph{igraph} graph object.}

\item{rand}{A character string indicating whether this function is being run
for a random graph or a "graph of interest" (default: \code{FALSE}).}
}
\value{
An \emph{igraph} graph object with additional vertex attributes:
  \item{lobe}{Character string indicating the lobe}
  \item{lobe.hemi}{Integer vector indicating the lobe and hemisphere}
  \item{circle.layout}{Integer vector for ordering the vertices for circle
    plots}
  \item{x, y, z, x.mni, y.mni, z.mni}{Spatial coordinates}
  \item{color.lobe}{Colors based on \emph{lobe}}
}
\description{
This function will assign vertex attributes \emph{lobe} and \emph{lobe.hemi}
for all vertices in a graph, given a specific atlas. It will also add an
attribute \emph{circle.layout} for plotting circular graphs.
}
\details{
The input graph \code{g} \emph{must} have a graph attribute named \code{atlas}.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
