% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_perm_diffs.R
\name{plot_perm_diffs}
\alias{plot_perm_diffs}
\title{Calculate permutation p-values and plot group differences}
\usage{
plot_perm_diffs(g1, g2, perm.dt, measure, level = c("graph", "vertex"),
  auc = FALSE, alternative = c("two.sided", "less", "greater"),
  alpha = 0.05, groups = NULL, ylabel = NULL)
}
\arguments{
\item{g1}{List of igraph graph objects for group 1}

\item{g2}{List of igraph graph objects for group 2}

\item{perm.dt}{Data table with the permutation results}

\item{measure}{Character string for the graph measure of interest}

\item{level}{Character string, either 'graph' or 'vertex'}

\item{auc}{Logical indicating whether the data refer to area-under-the-curve
(across all densities) (default: FALSE)}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: 'two.sided')}

\item{alpha}{Significance level (default: 0.05)}

\item{groups}{Character vector of group names (default: NULL)}

\item{ylabel}{Character string for y-axis label (default: NULL)}
}
\value{
A list with three elements:
\item{dt}{A data table with p-values for each density/region}
\item{p1}{A \code{\link[ggplot2]{ggplot}} plotting object}
\item{p2}{A \code{\link[ggplot2]{ggplot}} plotting object}
}
\description{
For a given (global- or vertex-level) graph measure, determine the
permutation p-value and create a plot showing group differences, either
across densities or regions. You may specify the \eqn{\alpha}-level; a red
asterisk is added if \eqn{p < \alpha} and a blue asterisk is added if
\eqn{\alpha < p < 0.1} (i.e. a "trend"). You may also choose whether you want
a one- or two-sided test.
}
\examples{
\dontrun{
perms.mod.sig <- perms.sig(g[[1]], g[[2]], perms.all, 'mod', level='graph',
  'less', groups, ylabel='Modularity')
perms.mod.btwn <- perms.sig(g[[1]], g[[2]], perms.btwn, 'btwn.cent',
  level='vertex')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link{permute.group}}
}

