##
## Example of 'var.rd=TRUE' parameter as a measure of the quality of the biplot - 2d
## Mainly recommended to large datasets.
##

library(bpca)
bp <- bpca(gabriel1971, meth='hj', lambda.end=2,
           var.rb=TRUE, var.rd=TRUE, limit=3)

bp$var.rd

# RUR followed by CRISTIAN contains information in dimensions that
# wasn't contemplated by the biplot reduction (PC3).
# Between all, RUR followed by CRISTIAN, variables are bad represented by a 2d
# biplot.

# Graphical visualization of the importance of the variables not contemplated
# in the reduction
plot(bpca(gabriel1971, meth='hj', lambda.ini=3, lambda.end=4), main='hj')
