% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/learn-methods.R
\docType{methods}
\name{learn.network}
\alias{learn.network}
\alias{learn.network,BN}
\alias{learn.network,BN-method}
\alias{learn.network,BNDataset}
\alias{learn.network,BNDataset-method}
\title{learn a network (structure and parameters) of a \link{BN} from a \link{BNDataset}.}
\usage{
learn.network(x, ...)

\S4method{learn.network}{BN}(x, y = NULL, algo = "mmhc",
  scoring.func = "BDeu", initial.network = NULL, alpha = 0.05, ess = 1,
  bootstrap = FALSE, layering = c(), max.fanin.layers = NULL,
  max.fanin = num.variables(dataset), layer.struct = NULL,
  cont.nodes = c(), use.imputed.data = FALSE, use.cpc = TRUE, ...)

\S4method{learn.network}{BNDataset}(x, algo = "mmhc", scoring.func = "BDeu",
  initial.network = NULL, alpha = 0.05, ess = 1, bootstrap = FALSE,
  layering = c(), max.fanin.layers = NULL,
  max.fanin = num.variables(dataset), layer.struct = NULL,
  cont.nodes = c(), use.imputed.data = FALSE, use.cpc = TRUE, ...)
}
\arguments{
\item{x}{can be a \code{\link{BN}} or a \code{\link{BNDataset}}. If \code{x} is a \code{\link{BN}},
then also the \code{dataset} parameter must be given.}

\item{...}{potential further arguments for methods.}

\item{y}{a \code{\link{BNDataset}} object, to be provided only if \code{x} is a \code{\link{BN}}.}

\item{algo}{the algorithm to use. Currently, one among:
\code{sm} (Silander-Myllymaki),
\code{mmhc} (Max-Min Hill Climbing, default) and
\code{sem} (Structural Expectation Maximization).}

\item{scoring.func}{the scoring function to use. Currently, one among
\code{BDeu}, \code{AIC}, \code{BIC}.}

\item{initial.network}{network srtructure to be used as starting point for structure search.
Can take different values:
a \code{BN} object, a matrix containing the adjacency matrix of the structure of the network,
or the string \code{random.chain} to sample a random chain as starting point.}

\item{alpha}{confidence threshold (only for \code{mmhc}).}

\item{ess}{Equivalent Sample Size value.}

\item{bootstrap}{\code{TRUE} to use bootstrap samples.}

\item{layering}{vector containing the layers each node belongs to.}

\item{max.fanin.layers}{matrix of available parents in each layer (only for \code{sm}).}

\item{max.fanin}{maximum number of parents for each node (only for \code{sm}).}

\item{layer.struct}{\code{0/1} matrix for indicating which layers can contain parent nodes
for nodes in a layer (only for \code{mmhc}).}

\item{cont.nodes}{vector containing the index of continuous variables.}

\item{use.imputed.data}{\code{TRUE} to learn the structure from the imputed dataset
(if available, a check is performed). Default is to use raw dataset}

\item{use.cpc}{(when using \code{mmhc}) compute Candidate Parent-and-Children sets instead of
starting the Hill Climbing from an empty graph.}
}
\value{
new \code{\link{BN}} object with structure (DAG) and conditional probabilities
as learnt from the given dataset.
}
\description{
Learn a network (structure and parameters) of a \link{BN} from a \link{BNDataset} (see the \code{Details} section).
}
\details{
Learn the structure (the directed acyclic graph) of a \code{\link{BN}} object according to a \code{\link{BNDataset}}.
We provide three algorithms in order to learn the structure of the network, that can be chosen with the \code{algo} parameter.
The first is the Silander-Myllym\"aki (\code{sm})
exact search-and-score algorithm, that performs a complete evaluation of the search space in order to discover
the best network; this algorithm may take a very long time, and can be inapplicable when discovering networks
with more than 25--30 nodes. Even for small networks, users are strongly encouraged to provide
meaningful parameters such as the layering of the nodes, or the maximum number of parents -- refer to the
documentation in package manual for more details on the method parameters.

The second algorithm (and the default one) is the Max-Min Hill-Climbing heuristic (\code{mmhc}), that performs a statistical
sieving of the search space followed by a greedy evaluation. It is considerably faster than the complete method,
at the cost of a (likely)
lower quality. Also note that in the case of a very dense network and lots of obsevations, the statistical evaluation
of the search space may take a long time. Also for this algorithm there are parameters that may need to be tuned,
mainly the confidence threshold of the statistical pruning.

The third method is the Structural Expectation-Maximization (\code{sem}) algorithm,
for learning a network from a dataset with missing values. It iterates a sequence of Expectation-Maximization (in order to ``fill in''
the holes in the dataset) and structure learning from the guessed dataset, until convergence. The structure learning used inside SEM,
due to computational reasons, is MMHC. Convergence of SEM can be controlled with the parameters \code{struct.threshold}
and \code{param.threshold}, for the structure and the parameter convergence, respectively.

Search-and-score methods also need a scoring function to compute an estimated measure of each configuration of nodes.
We provide three of the most popular scoring functions, \code{BDeu} (Bayesian-Dirichlet equivalent uniform, default),
\code{AIC} (Akaike Information Criterion) and \code{BIC} (Bayesian Information Criterion). The scoring function
can be chosen using the \code{scoring.func} parameter.

Then, the parameters of the network are learnt using MAP (Maximum A Posteriori) estimation (if not using bootstrap).

See documentation for \code{\link{learn.structure}} and \code{\link{learn.params}} for more informations.
}
\examples{
\dontrun{
mydataset <- BNDataset("data.file", "header.file")

# starting from a BN
net <- BN(mydataset)
net <- learn.network(net, mydataset)

# start directly from the dataset
net <- learn.network(mydataset)
}
}
\seealso{
learn.structure learn.params
}

