% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bmchoice.R
\name{Bmchoice}
\alias{Bmchoice}
\title{Model choice criteria calculation for univariate 
normal model for both known and unknown sigma^2}
\usage{
Bmchoice(
  case = "Exact.sigma2.known",
  y = ydata,
  mu0 = mean(y),
  sigma2 = 22,
  kprior = 1,
  prior.M = 1,
  prior.sigma2 = c(2, 1),
  N = 10000,
  rseed = 44
)
}
\arguments{
\item{case}{One of the three cases: 
\itemize{  
\item{"Exact.sigma2.known" }{Use exact theoretical calculation.}  
\item{"MC.sigma2.known" }{Use Monte Carlo methods for drawing samples from the 
posterior assuming known sigma2.}  
\item{"MC.sigma2.unknown" }{Use the Gibbs sampler to generate samples 
from the joint posterior distribution of theta and sigma^2.}
}}

\item{y}{A vector of data values. Default is 28 ydata values from the package bmstdr}

\item{mu0}{The value of the prior mean if kprior=0. Default is the data mean.}

\item{sigma2}{Value of the known data variance; defaults to sample variance of the data. This is ignored 
in the third case when sigma2 is assumed to be unknown.}

\item{kprior}{A scalar providing how many data standard deviation the prior
mean is from the data mean. Default value is 0.}

\item{prior.M}{Prior sample size, defaults to 10^(-4).}

\item{prior.sigma2}{Shape and scale parameter value for the gamma prior on 1/sigma^2, the precision.}

\item{N}{The number of samples to generate.}

\item{rseed}{The random number seed. Defaults to 44 to reproduce the results
in the book  \insertCite{Sahubook;textual}{bmstdr}.}
}
\value{
A list containing the exact values of pdic, dic, pdicalt, dicalt,
 pwaic1, waic1, pwaic2, waic2, gof, penalty and pmcc.
 Also prints out the posterior mean and variance.
 @references
\insertAllCited{}
}
\description{
Model choice criteria calculation for univariate 
normal model for both known and unknown sigma^2
}
\examples{
Bmchoice()
b1 <- Bmchoice(case="Exact.sigma2.known")
b2 <- Bmchoice(case="MC.sigma2.known")
d1 <- Bmchoice(case="MC.sigma2.unknown")
d2 <- Bmchoice(y=rt(100, df=8),  kprior=1, prior.M=1)

}
