% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bliss_Simulated_Annealing.R
\name{Bliss_Simulated_Annealing}
\alias{Bliss_Simulated_Annealing}
\title{Bliss_Simulated_Annealing}
\usage{
Bliss_Simulated_Annealing(beta_sample, normalization_values, param,
  verbose = FALSE)
}
\arguments{
\item{beta_sample}{a matrix. Each row is a coefficient function computed from the
posterior sample.}

\item{normalization_values}{a matrix given by the function \code{Bliss_Gibbs_Sampler}.}

\item{param}{a list containing:
\describe{
\item{grid}{a numerical vector, the time points.}
\item{K}{an integer, the number of intervals.}
\item{basis}{a character vector (optional). The possible values are "uniform"
      (default), "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates}
\item{burnin}{an integer (optional), the number of iteration to drop from the
      posterior sample.}
\item{iter_sann}{an integer (optional), the number of iteration of the Simulated
      Annealing algorithm.}
\item{k_max}{an integer (optional), the maximal number of intervals for the
      Simulated Annealing algorithm.}
\item{l_max}{an integer (optional), the maximal interval length for the
      Simulated Annealing algorithm.}
\item{Temp_init}{a nonnegative value (optional), the initial temperature for
     the cooling function of the Simulated Annealing algorithm.}
}}

\item{verbose}{write stuff if TRUE (optional).}
}
\value{
a list containing:
\describe{
 \item{Bliss_estimate}{a numerical vector, corresponding to the Bliss estimate
       of the coefficient function.}
 \item{Smooth_estimate}{a numerical vector, which is the posterior expectation
       of the coefficient function for each time points.}
 \item{trace}{a matrix, the trace of the algorithm.}
 \item{argmin}{an integer, the index of the iteration minimizing the Bliss loss.}
 \item{difference}{a numerical vector, the difference between the Bliss
       estimate and the smooth estimate.}
 \item{sdifference}{a numerical vector, a smooth version of \code{difference}.}
}
}
\description{
A Simulated Annealing algorithm to compute the Bliss estimate.
}
\examples{
\donttest{
data(data1)
data(param1)
param1$grids<-data1$grids
# result of res_bliss1<-fit_Bliss(data=data1,param=param1)
data(res_bliss1)
beta_sample <- compute_beta_sample(posterior_sample=res_bliss1$posterior_sample,
                                   param=param1,Q=1)
param_test<-list(grid=param1$grids[[1]],iter=1e3,K=2)
test<-Bliss_Simulated_Annealing(beta_sample[[1]],
                 res_bliss1$posterior_sample$param$normalization_values[[1]],
                 param=param_test)
ylim <- range(range(test$Bliss_estimate),range(test$Smooth_estimate))
plot(param_test$grid,test$Bliss_estimate,type="l",ylim=ylim)
lines(param_test$grid,test$Smooth_estimate,lty=2)
}
}
