% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{n_fix}
\alias{n_fix}
\title{Fixed Sample Size}
\usage{
n_fix(design, nuisance, ...)
}
\arguments{
\item{design}{test statistic object}

\item{nuisance}{nuisance parameter}

\item{...}{Further optional arguments.}
}
\value{
One value of the fixed sample size for every nuisance parameter
 and every value of n1.
}
\description{
Returns the sample size of a fixed design without sample size recalculation.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.

The method is implemented for the classes \code{\link{Student}},
\code{\link{ChiSquare}}, and \code{\link{FarringtonManning}}.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
n_fix(design = d, nuisance = 5.5)

}
