% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_funs.R
\name{kmbayes_parallel}
\alias{kmbayes_parallel}
\title{Run multiple BKMR chains in parallel}
\usage{
kmbayes_parallel(nchains = 4, ...)
}
\arguments{
\item{nchains}{number of parallel chains}

\item{...}{arguments to kmbayes}
}
\value{
a "bkmrfit.list" object, which is just an R list object in which each entry is a "bkmrfit" object \code{\link[bkmr]{kmbayes}}
}
\description{
Fit parallel chains from the \code{\link[bkmr]{kmbayes}} function.
These chains leverage parallel processing from the \code{future} package, which
can speed fitting and enable diagnostics that rely on multiple Markov
chains from dispersed initial values.
}
\examples{
\donttest{
set.seed(111)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)
Sys.setenv(R_FUTURE_SUPPORTSMULTICORE_UNSTABLE="quiet")
future::plan(strategy = future::multiprocess)
fitkm.list <- kmbayes_parallel(nchains=4, y = y, Z = Z, X = X, iter = 5000,
  verbose = FALSE, varsel = TRUE)
closeAllConnections()
}
}
