% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLocScaleGrid.R
\name{createLocScaleGrid}
\alias{createLocScaleGrid}
\title{Create a centered and scaled sparse integration grid}
\usage{
createLocScaleGrid(
  mu = 0,
  prec = 1,
  level = 2,
  quadError = FALSE,
  prec.chol = chol(prec)
)
}
\arguments{
\item{mu}{location at which grid should be centered}

\item{prec}{"precision matrix" associated with the integration grid.  When 
building a sparse integration grid for a density, \code{prec} is often 
the negative of the hessian at the mode.}

\item{level}{accuracy level.  This is typically number of grid points for the 
underlying 1D quadrature rule.  [description from mvQuad::createNIGrid]}

\item{quadError}{provide additional information about the grid points and 
integration weights for the quadrature rule with \code{level-1}.  This 
information can facilitate approximating the quadrature error.}

\item{prec.chol}{Upper-triangular Cholesky decomposition of precision matrix.}
}
\description{
Enhances mvQuad::createNIGrid by shifting and scaling a sparse integration
grid, and evaluating the weight function at each of the grid nodes.
}
\examples{
g = createLocScaleGrid(mu = c(1,0), prec = diag(c(1,.5)), level = 2 )

}
\seealso{
\code{mvQuad::createNIGrid}
}
