#include <array>
namespace coretools {
namespace {
constexpr std::array<double, 2004> getLog01LookupTable() {
	// -> returns array of length 2004, containing log lookup values
	// -> constructed with R script Dropbox/PhD/bangolin/approximations/TLogLookup.R
	// -> encoded in pairs: first value corresponds to intercept and second value corresponds to slope of linear
	// interpolation
	//    between two breakpoints
	// -> is constexpr: values are stored on the stack -> should be faster than reading them from the memory first
	//    however, if there are too many values, they need to be stored in heap anyways -> balance, depends on computer
	//    for us: 2000 doubles -> should be ok
	// -> if this is not desired -> replace 'constexpr' by 'const'
	return {-4.006364107453630, 20.212839318002455, -3.987340666282289, 19.831990025752201, -3.968672422399175,
	        19.465227604465131, -3.950346352568611, 19.111784656208911, -3.932350137015961, 18.770948530195191,
	        -3.914672109652035, 18.442056526045143, -3.897301212623892, 18.124491592702594, -3.880226954748946,
	        17.817678464263626, -3.863439373440438, 17.521080181795153, -3.846928999778293, 17.234194956899170,
	        -3.830686826418616, 16.956553338479520, -3.814704278069439, 16.687715649057136, -3.798973184289953,
	        16.427269661176261, -3.783485754397680, 16.174828488080365, -3.768234554290254, 15.930028665949715,
	        -3.753212485008875, 15.692528407702564, -3.738412762889444, 15.462006010728309, -3.723828901161323,
	        15.238158402934989, -3.709454692869746, 15.020699813307706, -3.695284195008645, 14.809360554704018,
	        -3.681311713762637, 14.603885907988863, -3.667531790766232, 14.404035097797594, -3.653939190297559,
	        14.209580351272015, -3.640528887330915, 14.020306032025362, -3.627296056380398, 13.836007842420532,
	        -3.614236061072226, 13.656492087951138, -3.601344444389541, 13.481574998159633, -3.588616919538270,
	        13.311082099086716, -3.576049361387358, 13.144847632748695, -3.563637798439903, 12.982714019573327,
	        -3.551378405297280, 12.824531360145308, -3.539267495579490, 12.670156972936503, -3.527301515268850,
	        12.519454965023289, -3.515477036448194, 12.372295833092247, -3.503790751404300, 12.228556092250333,
	        -3.492239467072535, 12.088117930420507, -3.480820099798287, 11.950868886276631, -3.469529670395041,
	        11.816701548883495, -3.458365299477292, 11.685513277331884, -3.447324203052257, 11.557205938858035,
	        -3.436403688351766, 11.431685664022053, -3.425601149889284, 11.308862617668748, -3.414914065728186,
	        11.188650784502940, -3.404339993946932, 11.070967768192032, -3.393876569289525, 10.955734603019089,
	        -3.383521499989067, 10.842875577173542, -3.373272564754443, 10.732318066856616, -3.363127609910164,
	        10.623992380436681, -3.353084546679035, 10.517831611939688, -3.343141348600676, 10.413771503244915,
	        -3.333296049076962, 10.311750314379218, -3.323546739037104, 10.211708701361299, -3.313891564715299,
	        10.113589601086920, -3.304328725535146, 10.017338122792536, -3.294856472093592, 9.922901445651451,
	        -3.285473104240335, 9.830228722117008,  -3.276176969245578, 9.739270986622632,  -3.266966460053141,
	        9.649981069313913,  -3.257840013612290, 9.562313514473146,  -3.248796109286125, 9.476224503361388,
	        -3.239833267330207, 9.391671781180660,  -3.230950047439764, 9.308614587921431,  -3.222145047359873,
	        9.227013592837864,  -3.213416901557443, 9.146830832350419,  -3.204764279949690, 9.068029651149292,
	        -3.196185886687360, 8.990574646318210,  -3.187680458990390, 8.914431614304020,  -3.179246766031826,
	        8.839567500550563,  -3.170883607868637, 8.765950351651517,  -3.162589814417306, 8.693549269878202,
	        -3.154364244471171, 8.622334369938915,  -3.146205784757737, 8.552276737845341,  -3.138113349034424,
	        8.483348391770718,  -3.130085877220795, 8.415522244787102,  -3.122122334564617, 8.348772069370018,
	        -3.114221710841679, 8.283072463585878,  -3.106383019586488, 8.218398818859345,  -3.098605297353016,
	        8.154727289240240,  -3.090887603003940, 8.092034762087708,  -3.083229017027276, 8.030298830097816,
	        -3.075628640878997, 7.969497764601988,  -3.068085596349578, 7.909610490062423,  -3.060599024956149,
	        7.850616559723984,  -3.053168087355006, 7.792496132329942,  -3.045791962777432, 7.735229949877417,
	        -3.038469848485424, 7.678799316340570,  -3.031200959247621, 7.623186077321650,  -3.023984526833462,
	        7.568372600574695,  -3.016819799526269, 7.514341757369714,  -3.009706041653209, 7.461076904645959,
	        -3.002642533131868, 7.408561867919141,  -2.995628569032987, 7.356780924907264,  -2.988663459158021,
	        7.305718789835449,  -2.981746527631572, 7.255360598391761,  -2.974877112507998, 7.205691893302320,
	        -2.968054565391025, 7.156698610491797,  -2.961278251066462, 7.108367065806291,  -2.954547547147317,
	        7.060683942270843,  -2.947861843730866, 7.013636277857064,  -2.941220543066688, 6.967211453733524,
	        -2.934623059236161, 6.921397182983417,  -2.928068817842093, 6.876181499761763,  -2.921557255708815,
	        6.831552748877403,  -2.915087820591598, 6.787499575775446,  -2.908659970895539, 6.744010916905701,
	        -2.902273175403605, 6.701075990460301,  -2.895926913013082, 6.658684287461316,  -2.889620672480540,
	        6.616825563185926,  -2.883353952174485, 6.575489828910990,  -2.877126259835996, 6.534667343966996,
	        -2.870937112346694, 6.494348608085651,  -2.864786035503862, 6.454524354029154,  -2.858672563802314,
	        6.415185540488168,  -2.852596240222900, 6.376323345238010,  -2.846556616027814, 6.337929158544747,
	        -2.840553250561348, 6.299994576803654,  -2.834585711057219, 6.262511396408757,  -2.828653572451101,
	        6.225471607836663,  -2.822756417199205, 6.188867389942436,  -2.816893835101772, 6.152691104452968,
	        -2.811065423131724, 6.116935290652441,  -2.805270785268717, 6.081592660254746,  -2.799509532337328,
	        6.046656092448652,  -2.793781281850429, 6.012118629116166,  -2.788085657856584, 5.977973470211198,
	        -2.782422290792355, 5.944213969298329,  -2.776790817338028, 5.910833629237443,  -2.771190880277763,
	        5.877826098015337,  -2.765622128364004, 5.845185164718275,  -2.760084216184844, 5.812904755633333,
	        -2.754576804035530, 5.780978930481094,  -2.749099557793728, 5.749401878773185,  -2.743652148797501,
	        5.718167916284585,  -2.738234253727116, 5.687271481643291,  -2.732845554489919, 5.656707133029346,
	        -2.727485738108313, 5.626469544979776,  -2.722154496610468, 5.596553505294024,  -2.716851526924265,
	        5.566953912039523,  -2.711576530773994, 5.537665770651504,  -2.706329214579496, 5.508684191122422,
	        -2.701109289358330, 5.480004385281307,  -2.695916470629968, 5.451621664154898,  -2.690750478322958,
	        5.423531435413040,  -2.685611036684424, 5.395729200892379,  -2.680497874191371, 5.368210554193059,
	        -2.675410723464942, 5.340971178352403,  -2.670349321186225, 5.314006843585670,  -2.665313408014746,
	        5.287313405097960,  -2.660302728508579, 5.260886800959466,  -2.655317031046511, 5.234723050044492,
	        -2.650356067752487, 5.208818250033441,  -2.645419594421248, 5.183168575470398,  -2.640507370446722,
	        5.157770275882583,  -2.635619158751114, 5.132619673949406,  -2.630754725716711, 5.107713163729933,
	        -2.625913841118497, 5.083047208937402,  -2.621096278059056, 5.058618341266876,  -2.616301812904543,
	        5.034423158768400,  -2.611530225222578, 5.010458324268624,  -2.606781297721330, 4.986720563835837,
	        -2.602054816190142, 4.963206665288952,  -2.597350569441474, 4.939913476748112,  -2.592668349254505,
	        4.916837905227338,  -2.588007950319569, 4.893976915264134,  -2.583369170184311, 4.871327527589241,
	        -2.578751809200809, 4.848886817831780,  -2.574155670474192, 4.826651915261435,  -2.569580559811915,
	        4.804620001562515,  -2.565026285674882, 4.782788309644857,  -2.560492659129140, 4.761154122484336,
	        -2.555979493798843, 4.739714771995643,  -2.551486605820340, 4.718467637935635,  -2.547013813797408,
	        4.697410146836662,  -2.542560938756623, 4.676539770964232,  -2.538127804105359, 4.655854027310101,
	        -2.533714235589100, 4.635350476604330,  -2.529320061250365, 4.615026722356561,  -2.524945111388795,
	        4.594880409923580,  -2.520589218521757, 4.574909225599586,  -2.516252217345623, 4.555110895729238,
	        -2.511933944698426, 4.535483185846141,  -2.507634239522853, 4.516023899831362,  -2.503352942830261,
	        4.496730879094571,  -2.499089897665325, 4.477602001775465,  -2.494844949071784, 4.458635181967067,
	        -2.490617944058228, 4.439828368955614,  -2.486408731565160, 4.421179546482062,  -2.482217162432985,
	        4.402686732023229,  -2.478043089369605, 4.384347976086117,  -2.473886366920001, 4.366161361525679,
	        -2.469746851435380, 4.348125002874752,  -2.465624401043570, 4.330237045693244,  -2.461518875619845,
	        4.312495665932542,  -2.457430136758463, 4.294899069315963,  -2.453358047744128, 4.277445490731508,
	        -2.449302473525536, 4.260133193645823,  -2.445263280687393, 4.242960469523497,  -2.441240337424862,
	        4.225925637268328,  -2.437233513517478, 4.209027042673529,  -2.433242680303895, 4.192263057886430,
	        -2.429267710657097, 4.175632080885710,  -2.425308478959822, 4.159132534969923,  -2.421364861081446,
	        4.142762868262114,  -2.417436734353820, 4.126521553219884,  -2.413523977548901, 4.110407086162397,
	        -2.409626470856039, 4.094417986805194,  -2.405744095860292, 4.078552797808266,  -2.401876735520236,
	        4.062810084330772,  -2.398024274147530, 4.047188433601491,  -2.394186597385653, 4.031686454494121,
	        -2.390363592189588, 4.016302777114565,  -2.386555146805935, 4.001036052397747,  -2.382761150753507,
	        3.985884951714034,  -2.378981494803588, 3.970848166481735,  -2.375216070961585, 3.955924407792440,
	        -2.371464772448217, 3.941112406041522,  -2.367727493681421, 3.926410910568424,  -2.364004130258492,
	        3.911818689304476,  -2.360294578938606, 3.897334528428831,  -2.356598737625782, 3.882957232032401,
	        -2.352916505351673, 3.868685621787335,  -2.349247782259417, 3.854518536626667,  -2.345592469587084,
	        3.840454832428254,  -2.341950469651848, 3.826493381707247,  -2.338321685834448, 3.812633073315241,
	        -2.334706022563357, 3.798872812143782,  -2.331103385300463, 3.785211518838900,  -2.327513680525364,
	        3.771648129515562,  -2.323936815721250, 3.758181595483217,  -2.320372699360916, 3.744810882976679,
	        -2.316821240891790, 3.731534972888155,  -2.313282350723206, 3.718352860512339,  -2.309755940211907,
	        3.705263555289463,  -2.306241921649372, 3.692266080559583,  -2.302740208248523, 3.679359473318887,
	        -2.299250714130610, 3.666542783980927,  -2.295773354312955, 3.653815076145134,  -2.292308044696259,
	        3.641175426367724,  -2.288854702052631, 3.628622923939246,  -2.285413244013565, 3.616156670665702,
	        -2.281983589057574, 3.603775780652223,  -2.278565656499821, 3.591479380097628,  -2.275159366479286,
	        3.579266607083612,  -2.271764639948686, 3.567136611377397,  -2.268381398663124, 3.555088554233151,
	        -2.265009565168822, 3.543121608197088,  -2.261649062793172, 3.531234956920471,  -2.258299815633871,
	        3.519427794972564,  -2.254961748548883, 3.507699327659560,  -2.251634787145864, 3.496048770844671,
	        -2.248318857772644, 3.484475350774890,  -2.245013887507628, 3.472978303910318,  -2.241719804149280,
	        3.461556876753132,  -2.238436536207773, 3.450210325686859,  -2.235164012894825, 3.438937916812000,
	        -2.231902164114999, 3.427738925789389,  -2.228650920456696, 3.416612637685044,  -2.225410213182774,
	        3.405558346816241,  -2.222179974222519, 3.394575356604678,  -2.218960136162790, 3.383662979429221,
	        -2.215750632239263, 3.372820536481319,  -2.212551396328658, 3.362047357626052,  -2.209362362940329,
	        3.351342781263287,  -2.206183467207850, 3.340706154190960,  -2.203014644882074, 3.330136831475507,
	        -2.199855832322021, 3.319634176317095,  -2.196706966488411, 3.309197559925710,  -2.193567984935398,
	        3.298826361393315,  -2.190438825803429, 3.288519967571641,  -2.187319427811835, 3.278277772951067,
	        -2.184209730251611, 3.268099179541946,  -2.181109672978395, 3.257983596758460,  -2.178019196405390,
	        3.247930441304079,  -2.174938241496754, 3.237939137060271,  -2.171866749760400, 3.228009114975055,
	        -2.168804663241720, 3.218139812956220,  -2.165751924516861, 3.208330675764711,  -2.162708476686140,
	        3.198581154910146,  -2.159674263368092, 3.188890708549858,  -2.156649228692515, 3.179258801386339,
	        -2.153633317295290, 3.169684904571829,  -2.150626474311065, 3.160168495607594,  -2.147628645368499,
	        3.150709058252766,  -2.144639776583367, 3.141306082427871,  -2.141659814553353, 3.131959064125018,
	        -2.138688706352203, 3.122667505317482,  -2.135726399523964, 3.113430913870859,  -2.132772842077282,
	        3.104248803455721,  -2.129827982480441, 3.095120693463870,  -2.126891769655596, 3.086046108923320,
	        -2.123964152973175, 3.077024580415034,  -2.121045082247601, 3.068055643994947,  -2.118134507730830,
	        3.059138841110439,  -2.115232380108541, 3.050273718526086,  -2.112338650494141, 3.041459828243883,
	        -2.109453270424316, 3.032696727429259,  -2.106576191854144, 3.023983978336875,  -2.103707367152170,
	        3.015321148237340,  -2.100846749095449, 3.006707809344892,  -2.097994290865715, 2.998143538749493,
	        -2.095149946043589, 2.989627918344028,  -2.092313668605040, 2.981160534759214,  -2.089485412916490,
	        2.972740979295471,  -2.086665133730405, 2.964368847857134,  -2.083852786181117, 2.956043740888282,
	        -2.081048325780102, 2.947765263307908,  -2.078251708412625, 2.939533024449945,  -2.075462890332577,
	        2.931346637998891,  -2.072681828159166, 2.923205721931710,  -2.069908478872142, 2.915109898456286,
	        -2.067142799808798, 2.907058793955875,  -2.064384748658711, 2.899052038927778,  -2.061634283461074,
	        2.891089267930372,  -2.058891362600447, 2.883170119526258,  -2.056155944802345, 2.875294236225761,
	        -2.053427989130546, 2.867461264436129,  -2.050707454983077, 2.859670854407618,  -2.047994302087652,
	        2.851922660178766,  -2.045288490499996, 2.844216339530615,  -2.042589980598134, 2.836551553930094,
	        -2.039898733080820, 2.828927968485897,  -2.037214708962847, 2.821345251896115,  -2.034537869572177,
	        2.813803076401744,  -2.031868176546424, 2.806301117738949,  -2.029205591829894, 2.798839055093544,
	        -2.026550077669626, 2.791416571053302,  -2.023901596613158, 2.784033351565661,  -2.021260111504457,
	        2.776689085890933,  -2.018625585481103, 2.769383466559569,  -2.015997981971593, 2.762116189330344,
	        -2.013377264691679, 2.754886953146398,  -2.010763397641925, 2.747695460095235,  -2.008156345103912,
	        2.740541415365520,  -2.005556071638546, 2.733424527210172,  -2.002962542082018, 2.726344506903573,
	        -2.000375721543417, 2.719301068703790,  -1.997795575402178, 2.712293929814849,  -1.995222069304841,
	        2.705322810347639,  -1.992655169162411, 2.698387433282933,  -1.990094841147995, 2.691487524435614,
	        -1.987541051693613, 2.684622812417170,  -1.984993767487911, 2.677793028601057,  -1.982452955473522,
	        2.670997907087573,  -1.979918582844196, 2.664237184668559,  -1.977390617042863, 2.657510600795031,
	        -1.974869025758254, 2.650817897541384,  -1.972353776923362, 2.644158819574929,  -1.969844838712287,
	        2.637533114121537,  -1.967342179538111, 2.630940530934431,  -1.964845768050663, 2.624380822263078,
	        -1.962355573133626, 2.617853742820727,  -1.959871563902943, 2.611359049755784,  -1.957393709703932,
	        2.604896502620132,  -1.954921980109136, 2.598465863339789,  -1.952456344916456, 2.592066896186635,
	        -1.949996774146423, 2.585699367748284,  -1.947543238040225, 2.579363046900243,  -1.945095707057736,
	        2.573057704778460,  -1.942654151875062, 2.566783114750920,  -1.940218543382635, 2.560539052391027,
	        -1.937788852682939, 2.554325295450343,  -1.935365051088850, 2.548141623833251,  -1.932947110121027,
	        2.541987819569473,  -1.930535001506559, 2.535863666790148,  -1.928128697176235, 2.529768951700678,
	        -1.925728169263374, 2.523703462557863,  -1.923333390101222, 2.517666989643685,  -1.920944332221514,
	        2.511659325242335,  -1.918560968352182, 2.505680263615383,  -1.916183271415928, 2.499729600979397,
	        -1.913811214527945, 2.493807135481700,  -1.911444770994405, 2.487912667178335,  -1.909083914310524,
	        2.482045998011225,  -1.906728618158748, 2.476206931785907,  -1.904378856407065, 2.470395274149860,
	        -1.902034603107372, 2.464610832571172,  -1.899695832493387, 2.458853416316392,  -1.897362518979379,
	        2.453122836430625,  -1.895034637158268, 2.447418905716296,  -1.892712161799865, 2.441741438712547,
	        -1.890395067849633, 2.436090251676101,  -1.888083330426466, 2.430465162559979,  -1.885776924821678,
	        2.424865990995404,  -1.883475826497072, 2.419292558271668,  -1.881180011083417, 2.413744687317233,
	        -1.878889454378968, 2.408222202681135,  -1.876604132347941, 2.402724930514513,  -1.874324021118911,
	        2.397252698552136,  -1.872049096983364, 2.391805336094549,  -1.869779336394320, 2.386382673990544,
	        -1.867514715964702, 2.380984544619261,  -1.865255212465936, 2.375610781873021,  -1.863000802826615,
	        2.370261221140517,  -1.860751464130976, 2.364935699289736,  -1.858507173617586, 2.359634054651587,
	        -1.856267908677918, 2.354356127003428,  -1.854033646854903, 2.349101757552739,  -1.851804365841774,
	        2.343870788921663,  -1.849580043480457, 2.338663065130646,  -1.847360657760731, 2.333478431584058,
	        -1.845146186818233, 2.328316735053294,  -1.842936608933659, 2.323177823662824,  -1.840731902531559,
	        2.318061546875470,  -1.838532046178509, 2.312967755476393,  -1.836337018582591, 2.307896301560290,
	        -1.834146798591509, 2.302847038515561,  -1.831961365191865, 2.297819821011353,  -1.829780697507457,
	        2.292814504982469,  -1.827604774798755, 2.287830947617159,  -1.825433576460942, 2.282869007341750,
	        -1.823267082023292, 2.277928543808511,  -1.821105271147869, 2.273009417882074,  -1.818948123628239,
	        2.268111491626066,  -1.816795619388638, 2.263234628290891,  -1.814647738482492, 2.258378692300187,
	        -1.812504461091425, 2.253543549238536,  -1.810365767524570, 2.248729065839973,  -1.808231638216604,
	        2.243935109973769,  -1.806102053727747, 2.239161550634755,  -1.803976994741759, 2.234408257929268,
	        -1.801856442065437, 2.229675103064610,  -1.799740376627356, 2.224961958336919,  -1.797628779477080,
	        2.220268697120217,  -1.795521631783809, 2.215595193854337,  -1.793418914835364, 2.210941324033691,
	        -1.791320610037906, 2.206306964197813,  -1.789226698913673, 2.201691991917618,  -1.787137163101425,
	        2.197096285787755,  -1.785051984354266, 2.192519725413287,  -1.782971144539532, 2.187962191401041,
	        -1.780894625637276, 2.183423565347972,  -1.778822409739828, 2.178903729831999,  -1.776754479050371,
	        2.174402568400790,  -1.774690815882376, 2.169919965562524,  -1.772631402658741, 2.165455806776129,
	        -1.770576221910364, 2.161009978440355,  -1.768525256276031, 2.156582367885847,  -1.766478488500860,
	        2.152172863364143,  -1.764435901435743, 2.147781354038965,  -1.762397478036651, 2.143407729977278,
	        -1.760363201363326, 2.139051882139152,  -1.758333054578729, 2.134713702369316,  -1.756307020948262,
	        2.130393083388345,  -1.754285083838733, 2.126089918783357,  -1.752267226717809, 2.121804102999874,
	        -1.750253433152799, 2.117535531332316,  -1.748243686810157, 2.113284099916125,  -1.746237971454820,
	        2.109049705719626,  -1.744236270948960, 2.104832246534734,  -1.742238569251594, 2.100631620969530,
	        -1.740244850417649, 2.096447728439820,  -1.738255098597261, 2.092280469161218,  -1.736269298034984,
	        2.088129744141142,  -1.734287433068959, 2.083995455170811,  -1.732309488130453, 2.079877504818079,
	        -1.730335447742720, 2.075775796418937,  -1.728365296520687, 2.071690234070805,  -1.726399019169801,
	        2.067620722624162,  -1.724436600485880, 2.063567167676329,  -1.722478025353658, 2.059529475562609,
	        -1.720523278746899, 2.055507553350756,  -1.718572345727156, 2.051501308832719,  -1.716625211443211,
	        2.047510650517838,  -1.714681861130378, 2.043535487625856,  -1.712742280110041, 2.039575730080457,
	        -1.710806453788733, 2.035631288501939,  -1.708874367657668, 2.031702074200880,  -1.706946007291863,
	        2.027787999171029,  -1.705021358349603, 2.023888976082972,  -1.703100406572027, 2.020004918278076,
	        -1.701183137782129, 2.016135739761350,  -1.699269537884332, 2.012281355195491,  -1.697359592863783,
	        2.008441679894450,  -1.695453288785862, 2.004616629817479,  -1.693550611795480, 2.000806121562813,
	        -1.691651548116238, 1.997010072361134,  -1.689756084050599, 1.993228400071126,  -1.687864205978173,
	        1.989461023171296,  -1.685975900356242, 1.985707860756348,  -1.684091153718220, 1.981968832529474,
	        -1.682209952673843, 1.978243858798152,  -1.680332283908202, 1.974532860467701,  -1.678458134181068,
	        1.970835759035465,  -1.676587490326873, 1.967152476586343,  -1.674720339253321, 1.963482935785678,
	        -1.672856667941819, 1.959827059875765,  -1.670996463446059, 1.956184772668794,  -1.669139712891938,
	        1.952555998542453,  -1.667286403477073, 1.948940662434785,  -1.665436522469955, 1.945338689838411,
	        -1.663590057209644, 1.941750006795823,  -1.661746995105395, 1.938174539894617,  -1.659907323635507,
	        1.934612216261247,  -1.658071030347801, 1.931062963557993,  -1.656238102858165, 1.927526709976224,
	        -1.654408528850662, 1.924003384232737,  -1.652582296076792, 1.920492915564493,  -1.650759392354860,
	        1.916995233723626,  -1.648939805570123, 1.913510268973954,  -1.647123523673229, 1.910037952084295,
	        -1.645310534680962, 1.906578214326223,  -1.643500826674666, 1.903130987467417,  -1.641694387800654,
	        1.899696203768867,  -1.639891206269189, 1.896273795979369,  -1.638091270354174, 1.892863697331437,
	        -1.636294568392764, 1.889465841537091,  -1.634501088784877, 1.886080162783482,  -1.632710819992786,
	        1.882706595728735,  -1.630923750540366, 1.879345075497164,  -1.629139869013255, 1.875995537676239,
	        -1.627359164057864, 1.872657918311437,  -1.625581624381243, 1.869332153902740,  -1.623807238750380,
	        1.866018181400086,  -1.622035995992197, 1.862715938200195,  -1.620267884992695, 1.859425362141789,
	        -1.618502894696864, 1.856146391502336,  -1.616741014108001, 1.852878964993667,  -1.614982232287472,
	        1.849623021758494,  -1.613226538354252, 1.846378501366531,  -1.611473921484612, 1.843145343810922,
	        -1.609724370911514, 1.839923489504162,  -1.607977875924392, 1.836712879274769,  -1.606234425868726,
	        1.833513454363596,  -1.604494010145439, 1.830325156419865,  -1.602756618211069, 1.827147927498627,
	        -1.601022239576649, 1.823981710055922,  -1.599290863807920, 1.820826446946372,  -1.597562480524520,
	        1.817682081418965,  -1.595837079400070, 1.814548557114476,  -1.594114650161470, 1.811425818061507,
	        -1.592395182588314, 1.808313808672740,  -1.590678666513357, 1.805212473743166,  -1.588965091821198,
	        1.802121758445073,  -1.587254448448539, 1.799041608325937,  -1.585546726383595, 1.795971969304799,
	        -1.583841915665699, 1.792912787669018,  -1.582140006385249, 1.789864010071675,  -1.580440988683012,
	        1.786825583527842,  -1.578744852749791, 1.783797455411524,  -1.577051588826553, 1.780779573453464,
	        -1.575361187203542, 1.777771885737147,  -1.573673638220041, 1.774774340696007,  -1.571988932264399,
	        1.771786887111100,  -1.570307059773491, 1.768809474107824,  -1.568628011232051, 1.765842051152417,
	        -1.566951777172906, 1.762884568050095,  -1.565278348176387, 1.759936974941734,  -1.563607714870039,
	        1.756999222301129,  -1.561939867928127, 1.754071260931894,  -1.560274798071840, 1.751153041965630,
	        -1.558612496068272, 1.748244516857963,  -1.556952952730770, 1.745345637386992,  -1.555296158918160,
	        1.742456355649814,  -1.553642105534759, 1.739576624060420,  -1.551990783529718, 1.736706395346476,
	        -1.550342183897404, 1.733845622547907,  -1.548696297676027, 1.730994259012462,  -1.547053115948583,
	        1.728152258395324,  -1.545412629841515, 1.725319574654789,  -1.543774830525097, 1.722496162050924,
	        -1.542139709212838, 1.719681975142588,  -1.540507257161266, 1.716876968785090,  -1.538877465669699,
	        1.714081098127880,  -1.537250326079949, 1.711294318612122,  -1.535625829775842, 1.708516585967970,
	        -1.534003968183482, 1.705747856213155,  -1.532384732770290, 1.702988085649478,  -1.530768115045076,
	        1.700237230861102,  -1.529154106558128, 1.697495248712869,  -1.527542698900072, 1.694762096346571,
	        -1.525933883702651, 1.692037731180474,  -1.524327652637390, 1.689322110905293,  -1.522723997416317,
	        1.686615193483660,  -1.521122909791127, 1.683916937146972,  -1.519524381552959, 1.681227300393297,
	        -1.517928404532370, 1.678546241985631,  -1.516334970598875, 1.675873720949434,  -1.514744071661104,
	        1.673209696571224,  -1.513155699665751, 1.670554128395163,  -1.511569846598196, 1.667906976222460,
	        -1.509986504481806, 1.665268200108575,  -1.508405665377511, 1.662637760360911,  -1.506827321384419,
	        1.660015617538244,  -1.505251464638300, 1.657401732446617,  -1.503678087312666, 1.654796066139583,
	        -1.502107181617387, 1.652198579914353,  -1.500538739799331, 1.649609235311330,  -1.498972754141713,
	        1.647027994111507,  -1.497409216963923, 1.644454818334684,  -1.495848120621228, 1.641889670237483,
	        -1.494289457504816, 1.639332512311947,  -1.492733220041250, 1.636783307283180,  -1.491179400692512,
	        1.634242018107966,  -1.489627991955595, 1.631708607972671,  -1.488078986362362, 1.629183040291591,
	        -1.486532376479339, 1.626665278705194,  -1.484988154907560, 1.624155287078484,  -1.483446314282140,
	        1.621653029498919,  -1.481906847272332, 1.619158470275130,  -1.480369746581107, 1.616671573934887,
	        -1.478835004945114, 1.614192305223682,  -1.477302615134348, 1.611720629102869,  -1.475772569951930,
	        1.609256510747979,  -1.474244862234070, 1.606799915547357,  -1.472719484849797, 1.604350809100427,
	        -1.471196430700512, 1.601909157215696,  -1.469675692720241, 1.599474925909876,  -1.468157263875029,
	        1.597048081405660,  -1.466641137163031, 1.594628590130616,  -1.465127305614085, 1.592216418715265,
	        -1.463615762289707, 1.589811533991845,  -1.462106500282910, 1.587413902992806,  -1.460599512717699,
	        1.585023492948808,  -1.459094792749393, 1.582640271288026,  -1.457592333564009, 1.580264205633999,
	        -1.456092128378132, 1.577895263804251,  -1.454594170439119, 1.575533413809446,  -1.453098453024348,
	        1.573178623851052,  -1.451604969441552, 1.570830862320730,  -1.450113713028122, 1.568490097798099,
	        -1.448624677151490, 1.566156299050220,  -1.447137855208554, 1.563829435029585,  -1.445653240625530,
	        1.561509474872776,  -1.444170826858090, 1.559196387899597,  -1.442690607390742, 1.556890143611020,
	        -1.441212575736997, 1.554590711688371,  -1.439736725439114, 1.552298061991872,  -1.438263050067815,
	        1.550012164559149,  -1.436791543222308, 1.547732989604209,  -1.435322198529849, 1.545460507515748,
	        -1.433855009645967, 1.543194688856449,  -1.432389970253894, 1.540935504361100,  -1.430927074064624,
	        1.538682924935676,  -1.429466314816805, 1.536436921656165,  -1.428007686276388, 1.534197465767043,
	        -1.426551182236535, 1.531964528680151,  -1.425096796517688, 1.529738081973825,  -1.423644522966950,
	        1.527518097390985,  -1.422194355458331, 1.525304546838554,  -1.420746287892471, 1.523097402386084,
	        -1.419300314196390, 1.520896636264442,  -1.417856428323494, 1.518702220864877,  -1.416414624253269,
	        1.516514128737642,  -1.414974895991333, 1.514332332591147,  -1.413537237568921, 1.512156805290277,
	        -1.412101643043256, 1.509987519856050,  -1.410668106496926, 1.507824449463786,  -1.409236622037945,
	        1.505667567442309,  -1.407807183799701, 1.503516847272997,  -1.406379785940647, 1.501372262588446,
	        -1.404954422644139, 1.499233787171360,  -1.403531088118492, 1.497101394953785,  -1.402109776596695,
	        1.494975060015833,  -1.400690482336146, 1.492854756584444,  -1.399273199618906, 1.490740459032931,
	        -1.397857922751105, 1.488632141879275,  -1.396444646063110, 1.486529779785542,  -1.395033363909244,
	        1.484433347556668,  -1.393624070667770, 1.482342820139621,  -1.392216760740652, 1.480258172622247,
	        -1.390811428553417, 1.478179380232280,  -1.389408068555082, 1.476106418336443,  -1.388006675218071,
	        1.474039262439547,  -1.386607243037918, 1.471977888183286,  -1.385209766533213, 1.469922271345386,
	        -1.383814240245681, 1.467872387838965,  -1.382420658739600, 1.465828213710925,  -1.381029016602173,
	        1.463789725141748,  -1.379639308443036, 1.461756898444038,  -1.378251528894371, 1.459729710061955,
	        -1.376865672610492, 1.457708136569873,  -1.375481734268170, 1.455692154672141,  -1.374099708565956,
	        1.453681741201376,  -1.372719590224668, 1.451676873118464,  -1.371341373986641, 1.449677527510758,
	        -1.369965054616111, 1.447683681591953,  -1.368590626898900, 1.445695312700920,  -1.367218085642194,
	        1.443712398300706,  -1.365847425674638, 1.441734915977989,  -1.364478641846008, 1.439762843441929,
	        -1.363111729027274, 1.437796158523588,  -1.361746682110459, 1.435834839175061,  -1.360383496008315,
	        1.433878863468353,  -1.359022165654540, 1.431928209595038,  -1.357662686003382, 1.429982855865036,
	        -1.356305052029696, 1.428042780706061,  -1.354949258728750, 1.426107962662696,  -1.353595301116164,
	        1.424178380395682,  -1.352243174227715, 1.422254012681007,  -1.350892873119370, 1.420334838409326,
	        -1.349544392867080, 1.418420836585061,  -1.348197728566655, 1.416511986325605,  -1.346852875333703,
	        1.414608266860626,  -1.345509828303527, 1.412709657531321,  -1.344168582630953, 1.410816137789576,
	        -1.342829133490439, 1.408927687197522,  -1.341491476075523, 1.407044285426174,  -1.340155605599284,
	        1.405165912255492,  -1.338821517293811, 1.403292547573059,  -1.337489206410307, 1.401424171373649,
	        -1.336158668218874, 1.399560763758353,  -1.334829898008494, 1.397702304934000,  -1.333502891086939,
	        1.395848775212452,  -1.332177642780612, 1.394000155009841,  -1.330854148434492, 1.392156424845934,
	        -1.329532403411982, 1.390317565343370,  -1.328212403094752, 1.388483557226907,  -1.326894142883003,
	        1.386654381323239,  -1.325577618194840, 1.384830018559605,  -1.324262824466646, 1.383010449963761,
	        -1.322949757152506, 1.381195656662671,  -1.321638411724779, 1.379385619882767,  -1.320328783673175,
	        1.377580320948157,  -1.319020868505510, 1.375779741281155,  -1.317714661746921, 1.373983862400691,
	        -1.316410158940159, 1.372192665922203,  -1.315107355645361, 1.370406133556825,  -1.313806247440131,
	        1.368624247111002,  -1.312506829919046, 1.366846988485313,  -1.311209098694140, 1.365074339674653,
	        -1.309913049394227, 1.363306282766807,  -1.308618677665374, 1.361542799942628,  -1.307325979170258,
	        1.359783873474666,  -1.306034949588566, 1.358029485727255,  -1.304745584616537, 1.356279619155402,
	        -1.303457879967177, 1.354534256304623,  -1.302171831369930, 1.352793379810022,  -1.300887434570785,
	        1.351056972395987,  -1.299604685331960, 1.349325016875296,  -1.298323579432160, 1.347597496149013,
	        -1.297044112666093, 1.345874393205390,  -1.295766280844704, 1.344155691119732,  -1.294490079794991,
	        1.342441373053700,  -1.293215505359794, 1.340731422254603,  -1.291942553397988, 1.339025822055204,
	        -1.290671219784071, 1.337324555872743,  -1.289401500408361, 1.335627607208770,  -1.288133391176882,
	        1.333934959648564,  -1.286866888010983, 1.332246596860203,  -1.285601986847695, 1.330562502594614,
	        -1.284338683639429, 1.328882660684763,  -1.283076974353832, 1.327207055045044,  -1.281816854973709,
	        1.325535669670761,  -1.280558321497407, 1.323868488638236,  -1.279301369937860, 1.322205496103140,
	        -1.278045996323476, 1.320546676301256,  -1.276792196697228, 1.318892013546888,  -1.275539967117231,
	        1.317241492233224,  -1.274289303656200, 1.315595096831228,  -1.273040202401762, 1.313952811889659,
	        -1.271792659455878, 1.312314622033934,  -1.270546670935521, 1.310680511966620,  -1.269302232971698,
	        1.309050466465781,  -1.268059341710191, 1.307424470385566,  -1.266817993310885, 1.305802508654956,
	        -1.265578183948205, 1.304184566277963,  -1.264339909810555, 1.302570628332523,  -1.263103167100553,
	        1.300960679970443,  -1.261867952034996, 1.299354706416984,  -1.260634260844510, 1.297752692970050,
	        -1.259402089773780, 1.296154625000123,  -1.258171435081332, 1.294560487949629,  -1.256942293039415,
	        1.292970267332423,  -1.255714659934121, 1.291383948733603,  -1.254488532065113, 1.289801517808803,
	        -1.253263905745706, 1.288222960283955,  -1.252040777302692, 1.286648261954716,  -1.250819143076361,
	        1.285077408686164,  -1.249598999420394, 1.283510386412306,  -1.248380342701801, 1.281947181135678,
	        -1.247163169300873, 1.280387778926940,  -1.245947475610997, 1.278832165924312,  -1.244733258038917,
	        1.277280328333578,  -1.243520513004237, 1.275732252427126,  -1.242309236939648, 1.274187924543910,
	        -1.241099426290815, 1.272647331088993,  -1.239891077516311, 1.271110458533129,  -1.238684187087367,
	        1.269577293412145,  -1.237478751488247, 1.268047822327090,  -1.236274767215621, 1.266522031943133,
	        -1.235072230779019, 1.264999908989829,  -1.233871138700464, 1.263481440260342,  -1.232671487514494,
	        1.261966612611170,  -1.231473273768055, 1.260455412961706,  -1.230276494020610, 1.258947828294076,
	        -1.229081144843879, 1.257443845652510,  -1.227887222821874, 1.255943452143089,  -1.226694724550830,
	        1.254446634933363,  -1.225503646639127, 1.252953381251965,  -1.224313985707328, 1.251463678388360,
	        -1.223125738387881, 1.249977513692192,  -1.221938901325426, 1.248494874573375,  -1.220753471176392,
	        1.247015748501305,  -1.219569444609149, 1.245540123004774,  -1.218386818303814, 1.244067985671438,
	        -1.217205588952378, 1.242599324147706,  -1.216025753258464, 1.241134126138157,  -1.214847307937354,
	        1.239672379405296,  -1.213670249715998, 1.238214071769303,  -1.212494575332766, 1.236759191107446,
	        -1.211320281537632, 1.235307725354042,  -1.210147365091931, 1.233859662499890,  -1.208975822768463,
	        1.232414990592134,  -1.207805651351265, 1.230973697733725,  -1.206636847635689, 1.229535772083243,
	        -1.205469408428354, 1.228101201854589,  -1.204303330546946, 1.226669975316478,  -1.203138610820405,
	        1.225242080792411,  -1.201975246088629, 1.223817506660063,  -1.200813233202554, 1.222396241351120,
	        -1.199652569024126, 1.220978273351004,  -1.198493250426197, 1.219563591198493,  -1.197335274292419,
	        1.218152183485339,  -1.196178637517319, 1.216744038856126,  -1.195023337006171, 1.215339146007858,
	        -1.193869369674951, 1.213937493689670,  -1.192716732450313, 1.212539070702556,  -1.191565422269568,
	        1.211143865899107,  -1.190415436080469, 1.209751868183010,  -1.189266770841391, 1.208363066509030,
	        -1.188119423521210, 1.206977449882639,  -1.186973391099103, 1.205595007359526,  -1.185828670564692,
	        1.204215728045557,  -1.184685258917930, 1.202839601096397,  -1.183543153169021, 1.201466615717193,
	        -1.182402350338482, 1.200096761162419,  -1.181262847456853, 1.198730026735302,  -1.180124641564991,
	        1.197366401787959,  -1.178987729713707, 1.196005875720732,  -1.177852108963968, 1.194648437982218,
	        -1.176717776386668, 1.193294078068770,  -1.175584729062658, 1.191942785524319,  -1.174452964082779,
	        1.190594549940200,  -1.173322478547655, 1.189249360954689,  -1.172193269567763, 1.187907208252875,
	        -1.171065334263323, 1.186568081566317,  -1.169938669764407, 1.185231970672965,  -1.168813273210631,
	        1.183898865396587,  -1.167689141751297, 1.182568755606727,  -1.166566272545360, 1.181241631218469,
	        -1.165444662761319, 1.179917482192093,  -1.164324309577166, 1.178596298532820,  -1.163205210180378,
	        1.177278070290600,  -1.162087361767834, 1.175962787559812,  -1.160970761545839, 1.174650440479094,
	        -1.159855406730120, 1.173341019231147,  -1.158741294545494, 1.172034514042139,  -1.157628422226277,
	        1.170730915182001,  -1.156516787015881, 1.169430212963750,  -1.155406386166911, 1.168132397743423,
	        -1.154297216941193, 1.166837459919909,  -1.153189276609509, 1.165545389934454,  -1.152082562451816,
	        1.164256178270728,  -1.150977071757123, 1.162969815454498,  -1.149872801823282, 1.161686292053192,
	        -1.148769749957191, 1.160405598675956,  -1.147667913474643, 1.159127725973295,  -1.146567289700234,
	        1.157852664636781,  -1.145467875967490, 1.156580405399021,  -1.144369669618577, 1.155310939033144,
	        -1.143272668004536, 1.154044256352892,  -1.142176868485073, 1.152780348212198,  -1.141082268428517,
	        1.151519205504966,  -1.139988865211948, 1.150260819165042,  -1.138896656220869, 1.149005180165659,
	        -1.137805638849507, 1.147752279519614,  -1.136715810500501, 1.146502108278740,  -1.135627168585030,
	        1.145254657533878,  -1.134539710522681, 1.144009918414557,  -1.133453433741472, 1.142767882088854,
	        -1.132368335677789, 1.141528539763155,  -1.131284413776379, 1.140291882681979,  -1.130201665490206,
	        1.139057902127650,  -1.129120088280580, 1.137826589420279,  -1.128039679617083, 1.136597935917518,
	        -1.126960436977305, 1.135371933014099,  -1.125882357847176, 1.134148572142047,  -1.124805439720721,
	        1.132927844770245,  -1.123729680099926, 1.131709742404122,  -1.122655076494991, 1.130494256585786,
	        -1.121581626424025, 1.129281378893514,  -1.120509327413187, 1.128071100941763,  -1.119438176996521,
	        1.126863414380826,  -1.118368172716058, 1.125658310896796,  -1.117299312121648, 1.124455782211219,
	        -1.116231592771038, 1.123255820081035,  -1.115165012229760, 1.122058416298300,  -1.114099568071124,
	        1.120863562690026,  -1.113035257876228, 1.119671251118048,  -1.111972079233823, 1.118481473478720,
	        -1.110910029740399, 1.117294221702867,  -1.109849107000083, 1.116109487755527,  -1.108789308624577,
	        1.114927263635731,  -1.107730632233223, 1.113747541376438,  -1.106673075452908, 1.112570313044279,
	        -1.105616635917980, 1.111395570739328,  -1.104561311270388, 1.110223306595113,  -1.103507099159420,
	        1.109053512778180,  -1.102453997241861, 1.107886181488140,  -1.101402003181894, 1.106721304957411,
	        -1.100351114651002, 1.105558875450971,  -1.099301329328114, 1.104398885266391,  -1.098252644899311,
	        1.103241326733367,  -1.097205059058099, 1.102086192213886,  -1.096158569505133, 1.100933474101793,
	        -1.095113173948260, 1.099783164822698,  -1.094068870102622, 1.098635256833961,  -1.093025655690367,
	        1.097489742624240,  -1.091983528440887, 1.096346614713622,  -1.090942486090590, 1.095205865653245,
	        -1.089902526382992, 1.094067488025264,  -1.088863647068585, 1.092931474442583,  -1.087825845904932,
	        1.091797817548830,  -1.086789120656526, 1.090666510018072,  -1.085753469094821, 1.089537544554728,
	        -1.084718888998180, 1.088410913893383,  -1.083685378151854, 1.087286610798643,  -1.082652934347976,
	        1.086164628064999,  -1.081621555385492, 1.085044958516641,  -1.080591239070134, 1.083927595007290,
	        -1.079561983214434, 1.082812530420107,  -1.078533785637676, 1.081699757667507,  -1.077506644165843,
	        1.080589269690991,  -1.076480556631641, 1.079481059461048,  -1.075455520874399, 1.078375119976929,
	        -1.074431534740101, 1.077271444266565,  -1.073408596081370, 1.076170025386429,  -1.072386702757347,
	        1.075070856421296,  -1.071365852633819, 1.073973930484254,  -1.070346043583020, 1.072879240716387,
	        -1.069327273483723, 1.071786780286751,  -1.068309540221184, 1.070696542392204,  -1.067292841687100,
	        1.069608520257246,  -1.066277175779583, 1.068522707133884,  -1.065262540403165, 1.067439096301516,
	        -1.064248933468720, 1.066357681066745,  -1.063236352893499, 1.065278454763305,  -1.062224796601051,
	        1.064201410751864,  -1.061214262521242, 1.063126542419936,  -1.060204748590174, 1.062053843181690,
	        -1.059196252750236, 1.060983306477892,  -1.058188772949987, 1.059914925775677,  -1.057182307144234,
	        1.058848694568523,  -1.056176853293911, 1.057784606376019,  -1.055172409366100, 1.056722654743785,
	        -1.054168973334041, 1.055662833243368,  -1.053166543177021, 1.054605135472033,  -1.052165116880420,
	        1.053549555052700,  -1.051164692435681, 1.052496085633814,  -1.050165267840220, 1.051444720889150,
	        -1.049166841097518, 1.050395454517800,  -1.048169410216967, 1.049348280243920,  -1.047172973213944,
	        1.048303191816700,  -1.046177528109755, 1.047260183010215,  -1.045183072931599, 1.046219247623278,
	        -1.044189605712543, 1.045180379479321,  -1.043197124491532, 1.044143572426309,  -1.042205627313341,
	        1.043108820336587,  -1.041215112228540, 1.042076117106753,  -1.040225577293503, 1.041045456657569,
	        -1.039237020570348, 1.040016832933801,  -1.038249440126968, 1.038990239904160,  -1.037262834036936,
	        1.037965671561105,  -1.036277200379545, 1.036943121920796,  -1.035292537239759, 1.035922585022944,
	        -1.034308842708188, 1.034904054930695,  -1.033326114881077, 1.033887525730529,  -1.032344351860269,
	        1.032872991532128,  -1.031363551753195, 1.031860446468272,  -1.030383712672866, 1.030849884694743,
	        -1.029404832737808, 1.029841300390172,  -1.028426910072083, 1.028834687755962,  -1.027449942805251,
	        1.027830041016166,  -1.026473929072340, 1.026827354417368,  -1.025498867013845, 1.025826622228592,
	        -1.024524754775683, 1.024827838741169,  -1.023551590509189, 1.023830998268647,  -1.022579372371101,
	        1.022836095146688,  -1.021608098523504, 1.021843123732923,  -1.020637767133858, 1.020852078406903,
	        -1.019668376374932, 1.019862953569936,  -1.018699924424823, 1.018875743645029,  -1.017732409466896,
	        1.017890443076745,  -1.016765829689801, 1.016907046331127,  -1.015800183287423, 1.015925547895574,
	        -1.014835468458887, 1.014945942278761,  -1.013871683408511, 1.013968224010506,  -1.012908826345808,
	        1.012992387641695,  -1.011946895485456, 1.012018427744167,  -1.010985889047282, 1.011046338910620,
	        -1.010025805256239, 1.010076115754506,  -1.009066642342384, 1.009107752909929,  -1.008108398540869,
	        1.008141245031561,  -1.007151072091912, 1.007176586794524,  -1.006194661240777, 1.006213772894305,
	        -1.005239164237761, 1.005252798046653,  -1.004284579338172, 1.004293656987487,  -1.003330904802309,
	        1.003336344472797,  -1.002378138895443, 1.002380855278547,  -1.001426279887798, 1.001427184200582,
	        -1.000475326054535, 1.000475326054535,  -0.999525275675729, 0.999525275675729};
}
} // namespace
} // namespace coretools
