% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_sparsematrix_from_matrix.R
\name{sparsematrix_from_matrix}
\alias{sparsematrix_from_matrix}
\title{Convert matrix to sparse matrix}
\usage{
sparsematrix_from_matrix(adj_mat)
}
\arguments{
\item{adj_mat}{Adjacency matrix.}
}
\value{
A sparse matrix of class dgCMatrix.
}
\description{
Converts adjacency matrices (class "matrix") to a sparse matrices (class "dgCMatrix").
}
\examples{
#make matrix
   my_matrix <- rep(0, 100)
   my_matrix[c(1, 11, 22, 33, 44, 54, 65, 76, 87, 97)] <- 1
   my_matrix <- matrix(data = my_matrix, nrow = 10, ncol = 10)
#convert to sparsematrix
   sparsematrix_from_matrix(adj_mat = my_matrix)
}
\keyword{dgCMatrix}
\keyword{matrix}
