% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{means}
\alias{means}
\title{Aesthetics for biplot class / group means}
\usage{
means (bp,  which = NULL, col = NULL, pch = 1, cex = 1, label = FALSE,
label.col = NULL,label.cex = 0.75, label.side = "bottom", label.offset = 0.5)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{which}{vector of which means to display, with default \code{bp$g}.}

\item{col}{mean colour, with default to sample colour.}

\item{pch}{mean plotting character, with default \code{o}.}

\item{cex}{mean character expansion, with default \code{1}.}

\item{label}{logical, whether means should be labelled or not, with default \code{TRUE}.}

\item{label.col}{vector of length g with the colour of the labels, defaulting to the
colour of the means.}

\item{label.cex}{label text expansion, with default \code{0.75}.}

\item{label.side}{side of the plotting character where label appears, with default \code{bottom}. Note that unlike
the argument \code{pos} in \code{text()}, options are "bottom", "left", "top", "right" and not 1, 2, 3, 4.}

\item{label.offset}{offset of the label from the mean point. See ?text for a detailed explanation of the
argument \code{offset}.}
}
\value{
A list with the following components is available:
\item{which}{which means to display.}
\item{col}{colour of the means.}
\item{pch}{plotting character of the means.}
\item{cex}{expansion of the plotting character of the means.}
\item{label}{logical, whether means should be labelled.}
\item{label.col}{colour of the label.}
\item{label.cex}{expansion of the label.}
\item{label.side}{side at which to plot the label of means.}
\item{label.offset}{offset of the label from the mean point.}
}
\description{
This function allows formatting changes to class means or group means.
}
\details{
The number of classes or groups (defined by group.aes) is indicated as \code{g}. If an argument is not of length \code{g},
recycling is used.
}
\examples{
biplot(iris[,1:4]) |> PCA() |>
          means(col = "purple", pch = 15, cex = 2) |> plot()
}
