\name{slope.bipartite}

\alias{slope.bipartite}

\title{Slope of extinction simulation}
\description{
Fits a hyperbolic function to the extinction simulation of \code{\link{second.extinct}}.
}

\usage{
slope.bipartite(object, plot.it = TRUE, ...)
}

\arguments{
  \item{object}{An object of class \dQuote{bipartite}, usually generated by \code{\link{second.extinct}}. }
  \item{plot.it}{Logical; want to see the graph? }
  \item{\dots}{Graphical parameters passed on to the \code{plot} command used for plotting, NOT to the \code{curve} command used for overlaying the curve. }
}
\details{
Function scales extinction sequences to values between 0 and 1 for each participant. The x-axis of the graph features
the proportion of exterminated participants, while the y-axis depicts the proportion of secondary extinctions.
Since these curves usually follow a hyperbolic function (see examples in Memmott et al. 2004), this is fitted to the
data.

At present, only a function of type \eqn{y \sim 1 - x^a} is fitted (using \code{nls}), i.e. without offset. While usually this
function provides very good fits, do check the graph and judge for yourself. Fitting this simple function makes its
parameter \sQuote{a} a measure of extinction vulnerability. The more gradual the secondary extinctions, the lower the absolute value of \sQuote{a}. Or, phrased differently, large absolute values of \sQuote{a} indicate a very abrupt die-off, indicative of high initial redundancy in the network.
}

\value{
Returns one number, the exponent of the fitted hyperbolic model.
}

\references{
Memmott, J., Waser, N. M. and Price, M. V. (2004) Tolerance of pollination networks to species extinctions. \emph{Proceedings of the Royal Society B} \bold{271}, 2605--2611
}

\author{ Carsten F. Dormann}

\note{
This function is not as vigorously tested as it should probably be. It worked fine for large networks, but small ones may behave strangely, I fathom.

Note also that it CANNOT fit concave curves! The most extreme is a linear decline of secondary extinctions with primary extinctions. The function can be adapted to handle this, but only at the expense of fitting another parameter.

}

\seealso{ \code{\link{second.extinct}} for generating the required input object. }

\examples{
data(Safariland)
ex <- second.extinct(Safariland, participant="low", method="ran", nrep=100,
details=FALSE)
slope.bipartite(ex)
}

\keyword{ package }
