% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_crop_position}
\alias{seq_crop_position}
\title{Crop sequences between two positions}
\usage{
seq_crop_position(x, position_in = 1, position_out = -1)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{position_in}{an integer giving the position where to start cropping.}

\item{position_out}{an integer giving the position where to stop cropping.}
}
\value{
A cropped DNA, RNA or AA vector.
}
\description{
Crop sequences between two positions
}
\examples{

x <- dna("ACGTTAGTGTAGCCGT")

# Drop the first 3 nucleotides (ACG)
seq_crop_position(x, position_in = 4)

# Crop codon between position 4 and 6
seq_crop_position(x, position_in = 4, position_out = 6)

}
\seealso{
\code{\link[stringi]{stri_sub}} from \pkg{stringi} and
\code{\link[stringr]{str_sub}} from \pkg{stringr}
for the underlying implementation.

Other string operations: \code{\link{seq-replace}},
  \code{\link{seq_combine}},
  \code{\link{seq_count_pattern}},
  \code{\link{seq_crop_pattern}},
  \code{\link{seq_detect_pattern}},
  \code{\link{seq_extract_pattern}},
  \code{\link{seq_extract_position}},
  \code{\link{seq_remove_pattern}},
  \code{\link{seq_remove_position}},
  \code{\link{seq_replace_position}},
  \code{\link{seq_split_kmer}},
  \code{\link{seq_split_pattern}}
}
\concept{string operations}
