% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_pam.R
\name{nhclu_pam}
\alias{nhclu_pam}
\title{Non hierarchical clustering: partitioning around medoids}
\usage{
nhclu_pam(
  dissimilarity,
  index = names(dissimilarity)[3],
  n_clust = NULL,
  nstart = if (variant == "faster") 1 else NA,
  variant = "faster",
  cluster_only = FALSE,
  ...
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{n_clust}{an \code{integer} or a \code{vector} of \code{integers} specifying the
requested number(s) of clusters.}

\item{nstart}{an \code{integer} specifying the number of random “starts” for the
pam algorithm. By default, 1 (for the \code{"faster"} variant).}

\item{variant}{a \code{character} string specifying the variant of pam to use,
by default "faster". Available options are original, o_1, o_2, f_3, f_4,
f_5 or fasterSee \link[cluster:pam]{cluster::pam()} for more details.}

\item{cluster_only}{a \code{boolean} specifying if only the clustering should be
returned from the \link[cluster:pam]{cluster::pam()} function (more efficient).}

\item{...}{you can add here further arguments to be passed to \code{pam()}
(see \link[cluster:pam]{cluster::pam()})}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \verb{character string} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}
}
\description{
This function performs non hierarchical clustering on the basis of
dissimilarity with partitioning around medoids.
}
\details{
This method partitions data into the chosen number of cluster on the basis
of the input dissimilarity matrix. It is more robust than k-means because it
minimizes the sum of dissimilarity between cluster centres and points
assigned to the cluster - whereas the k-means approach minimizes the sum of
squared euclidean distances (thus k-means cannot be applied directly on the
input dissimilarity matrix if the distances are not euclidean).
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

comnet <- mat_to_net(comat)
dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_pam(dissim, n_clust = 2:10, index = "Simpson")
clust2 <- nhclu_pam(dissim, n_clust = 2:15, index = "Simpson")
partition_metrics(clust2, dissimilarity = dissim,
eval_metric = "pc_distance")
partition_metrics(clust2, net = comnet, species_col = "Node2",
                   site_col = "Node1", eval_metric = "avg_endemism")
   
}
\references{
\insertRef{Kaufman2009}{bioregion}
}
\seealso{
\link{nhclu_kmeans}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
