% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_2.R, R/biomod2_classes_3.R
\docType{class}
\name{BIOMOD.stored.data}
\alias{BIOMOD.stored.data}
\alias{BIOMOD.stored.data-class}
\alias{BIOMOD.stored.array-class}
\alias{BIOMOD.stored.data.frame-class}
\alias{BIOMOD.stored.SpatRaster-class}
\alias{BIOMOD.stored.files-class}
\alias{BIOMOD.stored.formated.data-class}
\alias{BIOMOD.stored.models.options-class}
\alias{BIOMOD.stored.models.out-class}
\title{\code{BIOMOD_EnsembleModeling()} output object class}
\description{
Classes used by \code{\link{BIOMOD_Modeling}} and 
\code{\link{BIOMOD_EnsembleModeling}} to build their output object (see 
\code{\link{BIOMOD.models.out}} objects)
}
\details{
\code{BIOMOD.stored.data} is the basic object containing the slots \code{inMemory} and 
\code{link}. \cr All listed classes below are derived from \code{BIOMOD.stored.data}, and 
contain a \code{val} slot of specific type :

\itemize{
  \item{\code{BIOMOD.stored.array} : }{\code{val} is an \code{array}}
  \item{\code{BIOMOD.stored.data.frame} : }{\code{val} is a \code{data.frame}}
  \item{\code{BIOMOD.stored.SpatRaster} : }{\code{val} is a 
  \code{\link[terra:PackedSpatRaster-class]{PackedSpatRaster}}}
  \item{\code{BIOMOD.stored.files} : }{\code{val} is a \code{character}}
  \item{\code{BIOMOD.stored.formated.data} : }{\code{val} is a 
  \code{\link{BIOMOD.formated.data}} object}
  \item{\code{BIOMOD.stored.models.options} : }{\code{val} is a 
  \code{\link{BIOMOD.models.options}} object}
  \item{\code{BIOMOD.stored.models.out} : }{\code{val} is a 
  \code{\link{BIOMOD.models.out}} object}
}
}
\section{Slots}{

\describe{
\item{\code{inMemory}}{a \code{logical} defining whether the \code{val} slot has been loaded in 
memory or not}

\item{\code{link}}{a \code{character} containing the file name of the saved \code{val} slot}

\item{\code{val}}{an object of type depending on the \code{BIOMOD.stored.[...]} class (see Details)}
}}

\examples{

showClass("BIOMOD.stored.data")
showClass("BIOMOD.stored.array") 
showClass("BIOMOD.stored.data.frame") 
showClass("BIOMOD.stored.SpatRaster") 
showClass("BIOMOD.stored.files") 
showClass("BIOMOD.stored.formated.data") 
showClass("BIOMOD.stored.models.options") 
showClass("BIOMOD.stored.models.out") 


}
\seealso{
\code{\link{BIOMOD.formated.data}}, \code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}}, 
\code{\link{BIOMOD_Modeling}}, \code{\link{BIOMOD_EnsembleModeling}}, 
\code{\link{BIOMOD_Projection}}, \code{\link{BIOMOD_EnsembleForecasting}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.projection.out}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
