% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDS.R
\name{getCDS}
\alias{getCDS}
\title{Coding Sequence Retrieval}
\usage{
getCDS(db = "refseq", organism, path = file.path("_ncbi_downloads", "CDS"))
}
\arguments{
\item{db}{a character string specifying the database from which the genome shall be retrieved: \code{db = "refseq"}, \code{db = "genbank"}, \code{db = "ensembl"} or \code{db = "ensemblgenomes"}.}

\item{organism}{a character string specifying the scientific name of the organism of interest,\code{organism = "Homo sapiens"}.}

\item{path}{a character string specifying the location (a folder) in which the corresponding
CDS file shall be stored. Default is \code{path} = \code{file.path("_ncbi_downloads","CDS")}.}
}
\value{
File path to downloaded CDS file.
}
\description{
Main retrieval function for coding sequences (CDS) of an organism of interest.
By specifying the scientific name of an organism of interest the corresponding fasta-file storing the CDS information for the organism of interest
can be downloaded and stored locally. CDS files can be retrieved from several databases.
}
\examples{
\dontrun{
# download the genome of Arabidopsis thaliana from refseq
# and store the corresponding genome CDS file in '_ncbi_downloads/CDS'
file_path <- getCDS( db       = "refseq", 
             organism = "Arabidopsis thaliana", 
             path     = file.path("_ncbi_downloads","CDS"))

Ath_CDS <- read_cds(file_path, format = "fasta")

}
}
\seealso{
\code{\link{getGenome}}, \code{\link{getProteome}}, \code{\link{getGFF}}, \code{\link{meta.retrieval}}, \code{\link{read_cds}}
}
\author{
Hajk-Georg Drost
}
